/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.vault;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.Vault;
import org.jetbrains.annotations.Nullable;

public class InMemoryVault
implements Vault {
    private final Map<String, String> secrets = new ConcurrentHashMap<String, String>();
    private final Monitor monitor;

    public InMemoryVault(Monitor monitor) {
        this.monitor = monitor;
    }

    @Nullable
    public String resolveSecret(String s) {
        this.monitor.debug("resolving secret " + s, new Throwable[0]);
        if (s == null) {
            this.monitor.warning("Secret name is null - skipping", new Throwable[0]);
            return null;
        }
        return this.secrets.getOrDefault(s, null);
    }

    public Result<Void> storeSecret(String s, String s1) {
        this.monitor.debug("storing secret " + s, new Throwable[0]);
        this.secrets.put(s, s1);
        return Result.success();
    }

    public Result<Void> deleteSecret(String s) {
        this.monitor.debug("deleting secret " + s, new Throwable[0]);
        return this.secrets.remove(s) == null ? Result.failure((String)("Secret with key " + s + " does not exist")) : Result.success();
    }
}

