/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.security;

import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.KeyParser;
import org.eclipse.edc.spi.security.KeyParserRegistry;

public class KeyParserRegistryImpl
implements KeyParserRegistry {
    private final List<KeyParser> parsers = new ArrayList<KeyParser>();

    public void register(KeyParser parser) {
        this.parsers.add(parser);
    }

    public Result<Key> parse(String encoded) {
        return this.parsers.stream().filter(kp -> kp.canHandle(encoded)).findFirst().map(kp -> kp.parse(encoded)).orElseGet(() -> Result.failure((String)"No parser found that can handle that format."));
    }
}

