/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.security;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.edc.spi.iam.LocalPublicKeyService;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.KeyParserRegistry;
import org.eclipse.edc.spi.security.Vault;

public class LocalPublicKeyServiceImpl
implements LocalPublicKeyService {
    private final Vault vault;
    private final KeyParserRegistry registry;
    private final Map<String, PublicKey> cachedKeys = new HashMap<String, PublicKey>();

    public LocalPublicKeyServiceImpl(Vault vault, KeyParserRegistry registry) {
        this.vault = vault;
        this.registry = registry;
    }

    public Result<PublicKey> resolveKey(String id) {
        return this.resolveFromCache(id).map(Result::success).or(() -> this.resolveFromVault(id).map(this::parseKey)).orElseGet(() -> Result.failure((String)"No public key could be resolved for key-ID '%s'".formatted(id)));
    }

    private Optional<String> resolveFromVault(String id) {
        return Optional.ofNullable(this.vault.resolveSecret(id));
    }

    private Optional<PublicKey> resolveFromCache(String id) {
        return Optional.ofNullable(this.cachedKeys.get(id));
    }

    private Result<PublicKey> parseKey(String encodedKey) {
        return (Result)this.registry.parse(encodedKey).compose(pk -> {
            if (pk instanceof PublicKey) {
                PublicKey publicKey = (PublicKey)pk;
                return Result.success((Object)publicKey);
            }
            return Result.failure((String)"The specified resource did not contain public key material.");
        });
    }

    public Result<Void> addRawKey(String id, String rawKey) {
        return ((Result)this.parseKey(rawKey).onSuccess(pk -> this.cachedKeys.put(id, (PublicKey)pk))).mapTo();
    }
}

