/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.security.keyparsers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.KeyParser;

public class PemParser
implements KeyParser {
    private static final Pattern PEM_FORMAT_REGEX = Pattern.compile("(-----BEGIN\\s.*-----)[\\r]?\\n((?s:.*))(-----END\\s.*-----)", 8);
    private final JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
    private final Monitor monitor;

    public PemParser(Monitor monitor) {
        this.monitor = monitor;
    }

    public boolean canHandle(String encoded) {
        return PEM_FORMAT_REGEX.matcher(encoded).find();
    }

    public Result<Key> parse(String encoded) {
        Matcher matcher = PEM_FORMAT_REGEX.matcher(encoded);
        if (!matcher.find()) {
            return Result.failure((String)"The given input is not valid PEM.");
        }
        Result<List<KeyPair>> keypair = this.parseKeys(encoded);
        if (keypair.succeeded()) {
            List keyPairList = (List)keypair.getContent();
            if (keyPairList.size() > 1) {
                this.monitor.warning("PEM expected to contain exactly 1 key(-pair), but contained %s. Will take the first one. Please consider re-structuring your PEM document.".formatted(keyPairList.size()), new Throwable[0]);
            }
            return keyPairList.stream().filter(Objects::nonNull).map(keyPair -> keyPair.getPrivate() != null ? keyPair.getPrivate() : keyPair.getPublic()).findFirst().map(Result::success).orElseGet(() -> Result.failure((String)"PEM-encoded structure did not contain a private key."));
        }
        return keypair.mapTo();
    }

    private Result<List<KeyPair>> parseKeys(String pemEncodedKeys) {
        StringReader pemReader = new StringReader(pemEncodedKeys);
        PEMParser parser = new PEMParser((Reader)pemReader);
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>();
        try {
            Object pemObj;
            do {
                if ((pemObj = parser.readObject()) instanceof SubjectPublicKeyInfo) {
                    SubjectPublicKeyInfo subjectPublicKeyInfo = (SubjectPublicKeyInfo)pemObj;
                    keys.add(this.toKeyPair(subjectPublicKeyInfo));
                    continue;
                }
                if (pemObj instanceof X509CertificateHolder) {
                    X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)pemObj;
                    keys.add(this.toKeyPair(x509CertificateHolder));
                    continue;
                }
                if (pemObj instanceof PEMKeyPair) {
                    PEMKeyPair pemKeyPair = (PEMKeyPair)pemObj;
                    keys.add(this.toKeyPair(pemKeyPair));
                    continue;
                }
                if (!(pemObj instanceof PrivateKeyInfo)) continue;
                PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pemObj;
                keys.add(this.toKeyPair(privateKeyInfo));
            } while (pemObj != null);
            return Result.success(keys);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            this.monitor.warning("Error parsing PEM-encoded private key", new Throwable[]{e});
            return Result.failure((String)("Error parsing PEM-encoded private key: " + e.getMessage()));
        }
    }

    private KeyPair toKeyPair(SubjectPublicKeyInfo spki) throws PEMException {
        return new KeyPair(this.pemConverter.getPublicKey(spki), null);
    }

    private KeyPair toKeyPair(X509CertificateHolder pemObj) throws PEMException {
        SubjectPublicKeyInfo spki = pemObj.getSubjectPublicKeyInfo();
        return new KeyPair(this.pemConverter.getPublicKey(spki), null);
    }

    private KeyPair toKeyPair(PEMKeyPair pair) throws PEMException {
        return this.pemConverter.getKeyPair(pair);
    }

    private KeyPair toKeyPair(PrivateKeyInfo pki) throws PEMException, NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey privateKey = this.pemConverter.getPrivateKey(pki);
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            return new KeyPair(publicKey, privateKey);
        }
        return new KeyPair(null, privateKey);
    }
}

