/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.edc.connector.core.store.AssetPropertyLookup;
import org.eclipse.edc.connector.core.store.ContainsOperatorPredicate;
import org.eclipse.edc.connector.core.store.EqualOperatorPredicate;
import org.eclipse.edc.connector.core.store.InOperatorPredicate;
import org.eclipse.edc.connector.core.store.LikeOperatorPredicate;
import org.eclipse.edc.connector.core.store.ReflectionPropertyLookup;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.CriterionOperatorRegistry;
import org.eclipse.edc.spi.query.OperatorPredicate;
import org.eclipse.edc.spi.query.PropertyLookup;

public class CriterionOperatorRegistryImpl
implements CriterionOperatorRegistry {
    private final Map<String, OperatorPredicate> operatorPredicates = new HashMap<String, OperatorPredicate>();
    private final List<PropertyLookup> propertyLookups = new ArrayList<PropertyLookup>();

    public static CriterionOperatorRegistry ofDefaults() {
        CriterionOperatorRegistryImpl registry = new CriterionOperatorRegistryImpl();
        registry.registerPropertyLookup(new ReflectionPropertyLookup());
        registry.registerPropertyLookup(new AssetPropertyLookup());
        registry.registerOperatorPredicate("=", new EqualOperatorPredicate());
        registry.registerOperatorPredicate("in", new InOperatorPredicate());
        registry.registerOperatorPredicate("like", new LikeOperatorPredicate());
        registry.registerOperatorPredicate("contains", new ContainsOperatorPredicate());
        return registry;
    }

    public void registerOperatorPredicate(String operator, OperatorPredicate converter) {
        this.operatorPredicates.put(operator.toLowerCase(), converter);
    }

    public void registerPropertyLookup(PropertyLookup propertyLookup) {
        this.propertyLookups.add(0, propertyLookup);
    }

    public void unregister(String operator) {
        this.operatorPredicates.remove(operator.toLowerCase());
    }

    public boolean isSupported(String operator) {
        return this.operatorPredicates.containsKey(operator.toLowerCase());
    }

    public <T> Predicate<T> toPredicate(Criterion criterion) {
        OperatorPredicate predicate = this.operatorPredicates.get(criterion.getOperator().toLowerCase());
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Operator [%s] is not supported.", criterion.getOperator()));
        }
        return t -> {
            String operandLeft = (String)criterion.getOperandLeft();
            Object property = this.propertyLookups.stream().map(it -> it.getProperty(operandLeft, t)).filter(Objects::nonNull).findFirst().orElse(null);
            if (property == null) {
                return false;
            }
            return predicate.test(property, criterion.getOperandRight());
        };
    }
}

