/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.store;

import java.util.List;
import java.util.Objects;
import org.eclipse.edc.spi.query.OperatorPredicate;

public class EqualOperatorPredicate
implements OperatorPredicate {
    public boolean test(Object property, Object operandRight) {
        if (property.getClass().isEnum()) {
            Enum enumProperty = (Enum)property;
            if (operandRight instanceof String) {
                return Objects.equals(enumProperty.name(), operandRight);
            }
            if (operandRight instanceof Number) {
                return Objects.equals(enumProperty.ordinal(), operandRight);
            }
        }
        if (property instanceof Number) {
            Number c1 = (Number)property;
            if (operandRight instanceof Number) {
                Number c2 = (Number)operandRight;
                return Double.compare(c1.doubleValue(), c2.doubleValue()) == 0;
            }
        }
        if (property instanceof List) {
            List list = (List)property;
            return list.stream().anyMatch(it -> Objects.equals(it, operandRight));
        }
        return Objects.equals(property, operandRight);
    }
}

