/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.agent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.edc.spi.agent.ParticipantAgent;
import org.eclipse.edc.spi.agent.ParticipantAgentService;
import org.eclipse.edc.spi.agent.ParticipantAgentServiceExtension;
import org.eclipse.edc.spi.iam.ClaimToken;

public class ParticipantAgentServiceImpl
implements ParticipantAgentService {
    private final String identityClaimKey;
    private final List<ParticipantAgentServiceExtension> extensions = new ArrayList<ParticipantAgentServiceExtension>();

    public ParticipantAgentServiceImpl() {
        this.identityClaimKey = "client_id";
    }

    public ParticipantAgentServiceImpl(String key) {
        Objects.requireNonNull(key, "key");
        this.identityClaimKey = key;
    }

    public ParticipantAgent createFor(ClaimToken token) {
        Object claim;
        HashMap<String, String> attributes = new HashMap<String, String>();
        this.extensions.stream().map(extension -> extension.attributesFor(token)).forEach(attributes::putAll);
        if (!attributes.containsKey("edc:identity") && (claim = token.getClaim(this.identityClaimKey)) != null) {
            attributes.put("edc:identity", claim.toString());
        }
        return new ParticipantAgent(token.getClaims(), attributes);
    }

    public void register(ParticipantAgentServiceExtension extension) {
        this.extensions.add(extension);
    }
}

