/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.base;

import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.time.temporal.ChronoUnit;
import org.eclipse.edc.connector.core.base.RetryPolicyConfiguration;
import org.eclipse.edc.spi.monitor.Monitor;

public class RetryPolicyFactory {
    public static <T> RetryPolicy<T> create(RetryPolicyConfiguration configuration, Monitor monitor) {
        RetryPolicyBuilder builder = RetryPolicy.builder().withMaxRetries(configuration.getMaxRetries()).withBackoff((long)configuration.getMinBackoff(), (long)configuration.getMaxBackoff(), ChronoUnit.MILLIS);
        if (configuration.isLogOnRetry()) {
            builder.onRetry(event -> monitor.debug("Failsafe: execution attempted, will retry.", new Throwable[]{event.getLastException()}));
        }
        if (configuration.isLogOnRetryScheduled()) {
            builder.onRetryScheduled(event -> monitor.debug(String.format("Failsafe: execution scheduled, will retry in %s.", event.getDelay()), new Throwable[]{event.getLastException()}));
        }
        if (configuration.isLogOnRetriesExceeded()) {
            builder.onRetriesExceeded(event -> monitor.debug("Failsafe: maximum retries exceeded", new Throwable[]{event.getException()}));
        }
        if (configuration.isLogOnFailedAttempt()) {
            builder.onFailedAttempt(event -> monitor.debug("Failsafe: execution attempt failed", new Throwable[]{event.getLastException()}));
        }
        if (configuration.isLogOnAbort()) {
            builder.onAbort(event -> monitor.debug("Failsafe: execution aborted", new Throwable[]{event.getException()}));
        }
        return builder.build();
    }
}

