/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.base;

public class RetryPolicyConfiguration {
    private int maxRetries;
    private int minBackoff = 1;
    private int maxBackoff = Integer.MAX_VALUE;
    private boolean logOnRetry;
    private boolean logOnRetryScheduled;
    private boolean logOnRetriesExceeded;
    private boolean logOnFailedAttempt;
    private boolean logOnAbort;

    private RetryPolicyConfiguration() {
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getMinBackoff() {
        return this.minBackoff;
    }

    public int getMaxBackoff() {
        return this.maxBackoff;
    }

    public boolean isLogOnRetry() {
        return this.logOnRetry;
    }

    public boolean isLogOnRetryScheduled() {
        return this.logOnRetryScheduled;
    }

    public boolean isLogOnRetriesExceeded() {
        return this.logOnRetriesExceeded;
    }

    public boolean isLogOnFailedAttempt() {
        return this.logOnFailedAttempt;
    }

    public boolean isLogOnAbort() {
        return this.logOnAbort;
    }

    public static class Builder {
        private final RetryPolicyConfiguration instance = new RetryPolicyConfiguration();

        public static Builder newInstance() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder maxRetries(int maxRetries) {
            this.instance.maxRetries = maxRetries;
            return this;
        }

        public Builder minBackoff(int minBackoff) {
            this.instance.minBackoff = minBackoff;
            return this;
        }

        public Builder maxBackoff(int maxBackoff) {
            this.instance.maxBackoff = maxBackoff;
            return this;
        }

        public Builder logOnRetry(boolean logOnRetry) {
            this.instance.logOnRetry = logOnRetry;
            return this;
        }

        public Builder logOnRetryScheduled(boolean logOnRetryScheduled) {
            this.instance.logOnRetryScheduled = logOnRetryScheduled;
            return this;
        }

        public Builder logOnRetriesExceeded(boolean logOnRetriesExceeded) {
            this.instance.logOnRetriesExceeded = logOnRetriesExceeded;
            return this;
        }

        public Builder logOnFailedAttempt(boolean logOnFailedAttempt) {
            this.instance.logOnFailedAttempt = logOnFailedAttempt;
            return this;
        }

        public Builder logOnAbort(boolean logOnAbort) {
            this.instance.logOnAbort = logOnAbort;
            return this;
        }

        public RetryPolicyConfiguration build() {
            return this.instance;
        }
    }
}

