/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.command;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edc.spi.command.CommandHandler;
import org.eclipse.edc.spi.command.CommandHandlerRegistry;
import org.eclipse.edc.spi.command.CommandResult;
import org.eclipse.edc.spi.command.EntityCommand;

public class CommandHandlerRegistryImpl
implements CommandHandlerRegistry {
    private final Map<Class<? extends EntityCommand>, CommandHandler<?>> registrations = new HashMap();

    public <C extends EntityCommand> void register(CommandHandler<C> handler) {
        this.registrations.put(handler.getType(), handler);
    }

    public <C extends EntityCommand> CommandResult execute(C command) {
        CommandHandler<?> commandHandler = this.registrations.get(command.getClass());
        if (commandHandler == null) {
            return CommandResult.notExecutable((String)String.format("Command type %s cannot be executed", command.getClass()));
        }
        return commandHandler.handle(command);
    }
}

