/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.message;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.message.RemoteMessageDispatcher;
import org.eclipse.edc.spi.message.RemoteMessageDispatcherRegistry;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;

public class RemoteMessageDispatcherRegistryImpl
implements RemoteMessageDispatcherRegistry {
    private final Map<String, RemoteMessageDispatcher> dispatchers = new HashMap<String, RemoteMessageDispatcher>();

    public void register(RemoteMessageDispatcher dispatcher) {
        this.dispatchers.put(dispatcher.protocol(), dispatcher);
    }

    public <T> CompletableFuture<StatusResult<T>> dispatch(Class<T> responseType, RemoteMessage message) {
        Objects.requireNonNull(message, "Message was null");
        String protocol = message.getProtocol();
        RemoteMessageDispatcher dispatcher = this.dispatchers.get(protocol);
        if (dispatcher == null) {
            return CompletableFuture.failedFuture((Throwable)new EdcException("No provider dispatcher registered for protocol: " + protocol));
        }
        return dispatcher.dispatch(responseType, message);
    }
}

