/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core;

import org.eclipse.edc.api.auth.spi.ControlClientAuthenticationProvider;
import org.eclipse.edc.connector.core.agent.ParticipantAgentServiceImpl;
import org.eclipse.edc.connector.core.command.CommandHandlerRegistryImpl;
import org.eclipse.edc.connector.core.event.EventExecutorServiceContainer;
import org.eclipse.edc.connector.core.event.EventRouterImpl;
import org.eclipse.edc.connector.core.message.RemoteMessageDispatcherRegistryImpl;
import org.eclipse.edc.connector.core.validator.DataAddressValidatorRegistryImpl;
import org.eclipse.edc.connector.core.validator.JsonObjectValidatorRegistryImpl;
import org.eclipse.edc.http.client.ControlApiHttpClientImpl;
import org.eclipse.edc.http.spi.ControlApiHttpClient;
import org.eclipse.edc.http.spi.EdcHttpClient;
import org.eclipse.edc.json.JacksonTypeManager;
import org.eclipse.edc.policy.engine.PolicyEngineImpl;
import org.eclipse.edc.policy.engine.RuleBindingRegistryImpl;
import org.eclipse.edc.policy.engine.ScopeFilter;
import org.eclipse.edc.policy.engine.spi.PolicyEngine;
import org.eclipse.edc.policy.engine.spi.RuleBindingRegistry;
import org.eclipse.edc.policy.model.PolicyRegistrationTypes;
import org.eclipse.edc.query.CriterionOperatorRegistryImpl;
import org.eclipse.edc.runtime.metamodel.annotation.BaseExtension;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.agent.ParticipantAgentService;
import org.eclipse.edc.spi.command.CommandHandlerRegistry;
import org.eclipse.edc.spi.event.EventRouter;
import org.eclipse.edc.spi.message.RemoteMessageDispatcherRegistry;
import org.eclipse.edc.spi.query.CriterionOperatorRegistry;
import org.eclipse.edc.spi.system.Hostname;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.transform.TypeTransformerRegistryImpl;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.DataAddressValidatorRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;

@BaseExtension
@Extension(value="Core Services")
public class CoreServicesExtension
implements ServiceExtension {
    public static final String NAME = "Core Services";
    private static final String DEFAULT_EDC_HOSTNAME = "localhost";
    @Setting(value="Connector hostname, which e.g. is used in referer urls", defaultValue="localhost")
    public static final String EDC_HOSTNAME = "edc.hostname";
    @Setting(value="The name of the claim key used to determine the participant identity", defaultValue="client_id")
    public static final String EDC_AGENT_IDENTITY_KEY = "edc.agent.identity.key";
    @Inject
    private EventExecutorServiceContainer eventExecutorServiceContainer;
    @Inject(required=false)
    private TypeManager typeManager;
    @Inject
    private EdcHttpClient edcHttpClient;
    @Inject
    private ControlClientAuthenticationProvider controlClientAuthenticationProvider;
    private RuleBindingRegistry ruleBindingRegistry;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        this.ruleBindingRegistry = new RuleBindingRegistryImpl();
    }

    public void shutdown() {
        super.shutdown();
    }

    public void prepare() {
        PolicyRegistrationTypes.TYPES.forEach(arg_0 -> CoreServicesExtension.lambda$prepare$0(this.typeManager(), arg_0));
    }

    @Provider
    public TypeManager typeManager() {
        if (this.typeManager == null) {
            this.typeManager = new JacksonTypeManager();
        }
        return this.typeManager;
    }

    @Provider
    public Hostname hostname(ServiceExtensionContext context) {
        String hostname = context.getSetting(EDC_HOSTNAME, DEFAULT_EDC_HOSTNAME);
        if (DEFAULT_EDC_HOSTNAME.equals(hostname)) {
            context.getMonitor().warning(String.format("Settings: No setting found for key '%s'. Using default value '%s'", EDC_HOSTNAME, DEFAULT_EDC_HOSTNAME), new Throwable[0]);
        }
        return () -> hostname;
    }

    @Provider
    public RemoteMessageDispatcherRegistry remoteMessageDispatcherRegistry() {
        return new RemoteMessageDispatcherRegistryImpl();
    }

    @Provider
    public CommandHandlerRegistry commandHandlerRegistry() {
        return new CommandHandlerRegistryImpl();
    }

    @Provider
    public ParticipantAgentService participantAgentService(ServiceExtensionContext context) {
        String identityKey = context.getSetting(EDC_AGENT_IDENTITY_KEY, "client_id");
        return new ParticipantAgentServiceImpl(identityKey);
    }

    @Provider
    public RuleBindingRegistry ruleBindingRegistry() {
        return this.ruleBindingRegistry;
    }

    @Provider
    public PolicyEngine policyEngine() {
        ScopeFilter scopeFilter = new ScopeFilter(this.ruleBindingRegistry);
        return new PolicyEngineImpl(scopeFilter);
    }

    @Provider
    public EventRouter eventRouter(ServiceExtensionContext context) {
        return new EventRouterImpl(context.getMonitor(), this.eventExecutorServiceContainer.getExecutorService());
    }

    @Provider
    public TypeTransformerRegistry typeTransformerRegistry() {
        return new TypeTransformerRegistryImpl();
    }

    @Provider
    public JsonObjectValidatorRegistry jsonObjectValidator() {
        return new JsonObjectValidatorRegistryImpl();
    }

    @Provider
    public DataAddressValidatorRegistry dataAddressValidatorRegistry(ServiceExtensionContext context) {
        return new DataAddressValidatorRegistryImpl(context.getMonitor());
    }

    @Provider
    public CriterionOperatorRegistry criterionOperatorRegistry() {
        return CriterionOperatorRegistryImpl.ofDefaults();
    }

    @Provider
    public ControlApiHttpClient controlApiHttpClient() {
        return new ControlApiHttpClientImpl(this.edcHttpClient, this.controlClientAuthenticationProvider);
    }

    private static /* synthetic */ void lambda$prepare$0(TypeManager rec$, Class xva$0) {
        rec$.registerTypes(new Class[]{xva$0});
    }
}

