/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.base;

public class OkHttpClientConfiguration {
    private boolean enforceHttps;
    private int connectTimeout;
    private int readTimeout;
    private int sendBufferSize;
    private int receiveBufferSize;

    private OkHttpClientConfiguration() {
    }

    public boolean isEnforceHttps() {
        return this.enforceHttps;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public static class Builder {
        private final OkHttpClientConfiguration instance = new OkHttpClientConfiguration();

        public static Builder newInstance() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder enforceHttps(boolean enforceHttps) {
            this.instance.enforceHttps = enforceHttps;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.instance.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.instance.readTimeout = readTimeout;
            return this;
        }

        public Builder sendBufferSize(int sendBufferSize) {
            this.instance.sendBufferSize = sendBufferSize;
            return this;
        }

        public Builder receiveBufferSize(int receiveBufferSize) {
            this.instance.receiveBufferSize = receiveBufferSize;
            return this;
        }

        public OkHttpClientConfiguration build() {
            return this.instance;
        }
    }
}

