/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.base;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.eclipse.edc.connector.core.base.OkHttpClientConfiguration;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.monitor.Monitor;
import org.jetbrains.annotations.NotNull;

public class OkHttpClientFactory {
    @NotNull
    public static OkHttpClient create(OkHttpClientConfiguration configuration, EventListener okHttpEventListener, Monitor monitor) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout((long)configuration.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)configuration.getReadTimeout(), TimeUnit.SECONDS);
        if (configuration.getSendBufferSize() > 0 || configuration.getReceiveBufferSize() > 0) {
            builder.socketFactory((SocketFactory)new CustomSocketFactory(configuration.getSendBufferSize(), configuration.getReceiveBufferSize()));
        }
        Optional.ofNullable(okHttpEventListener).ifPresent(arg_0 -> ((OkHttpClient.Builder)builder).eventListener(arg_0));
        if (configuration.isEnforceHttps()) {
            builder.addInterceptor((Interceptor)new EnforceHttps());
        } else {
            monitor.info("HTTPS enforcement it not enabled, please enable it in a production environment", new Throwable[0]);
        }
        return builder.build();
    }

    private static class CustomSocketFactory
    extends SocketFactory {
        private final int sendBufferSize;
        private final int receiveBufferSize;

        CustomSocketFactory(int sendBufferSize, int receiveBufferSize) {
            this.sendBufferSize = sendBufferSize;
            this.receiveBufferSize = receiveBufferSize;
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.updateSendBufferSize(new Socket());
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.updateSendBufferSize(new Socket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.updateSendBufferSize(new Socket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.updateSendBufferSize(new Socket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.updateSendBufferSize(new Socket(address, port, localAddress, localPort));
        }

        private Socket updateSendBufferSize(Socket socket) throws IOException {
            if (this.receiveBufferSize > 0) {
                socket.setReceiveBufferSize(this.receiveBufferSize);
            }
            if (this.sendBufferSize > 0) {
                socket.setSendBufferSize(this.sendBufferSize);
            }
            return socket;
        }
    }

    private static class EnforceHttps
    implements Interceptor {
        private EnforceHttps() {
        }

        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            if (!request.isHttps()) {
                throw new EdcException(String.format("HTTP call to %s blocked due to HTTPS enforcement enabled", request.url()));
            }
            return chain.proceed(request);
        }
    }
}

