/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.edc.keys.LocalPublicKeyServiceImpl;
import org.eclipse.edc.keys.spi.KeyParserRegistry;
import org.eclipse.edc.keys.spi.LocalPublicKeyService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.configuration.Config;

@Extension(value="Security Default Services Extension")
@Provides(value={LocalPublicKeyService.class})
public class LocalPublicKeyDefaultExtension
implements ServiceExtension {
    public static final String NAME = "Local Public Key Default Extension";
    public static final String EDC_PUBLIC_KEYS_PREFIX = "edc.iam.publickeys";
    public static final String CONFIG_ALIAS = "edc.iam.publickeys.<pkAlias>.";
    @Setting(context="edc.iam.publickeys.<pkAlias>.", value="ID of the public key.", required=true)
    public static final String ID_SUFFIX = "id";
    @Setting(context="edc.iam.publickeys.<pkAlias>.", value="Value of the public key. Multiple formats are supported, depending on the KeyParsers registered in the runtime")
    public static final String VALUE_SUFFIX = "value";
    @Setting(context="edc.iam.publickeys.<pkAlias>.", value="Path to a file that holds the public key, e.g. a PEM file. Multiple formats are supported, depending on the KeyParsers registered in the runtime")
    public static final String PATH_SUFFIX = "path";
    @Inject
    public KeyParserRegistry keyParserRegistry;
    private Config keysConfiguration;
    private LocalPublicKeyServiceImpl localPublicKeyService;
    @Inject
    private Vault vault;

    @Provider(isDefault=true)
    public LocalPublicKeyService localPublicKeyService() {
        return this.localPublicKeyServiceImpl();
    }

    private LocalPublicKeyServiceImpl localPublicKeyServiceImpl() {
        if (this.localPublicKeyService == null) {
            this.localPublicKeyService = new LocalPublicKeyServiceImpl(this.vault, this.keyParserRegistry);
        }
        return this.localPublicKeyService;
    }

    public void initialize(ServiceExtensionContext context) {
        this.keysConfiguration = context.getConfig(EDC_PUBLIC_KEYS_PREFIX);
    }

    public void prepare() {
        if (this.keysConfiguration != null) {
            Result result = this.keysConfiguration.partition().map(this::readPublicKey).map(entry -> this.localPublicKeyServiceImpl().addRawKey((String)entry.getKey(), (String)entry.getValue())).reduce(Result.success(), Result::merge);
            result.orElseThrow(failure -> new EdcException(failure.getFailureDetail()));
        }
    }

    private Map.Entry<String, String> readPublicKey(Config config) {
        String id = config.getString(ID_SUFFIX);
        return this.readFrom(config, VALUE_SUFFIX, Function.identity()).or(() -> this.readFrom(config, PATH_SUFFIX, this::readFromPath)).map(key -> Map.entry(id, key)).orElseThrow(() -> new EdcException(""));
    }

    private String readFromPath(String path) {
        try {
            return Files.readString(Path.of(path, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<String> readFrom(Config config, String setting, Function<String, String> mapper) {
        return Optional.ofNullable(config.getString(setting, null)).map(mapper);
    }
}

