/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.core.validator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.validator.spi.DataAddressValidatorRegistry;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.jetbrains.annotations.NotNull;

public class DataAddressValidatorRegistryImpl
implements DataAddressValidatorRegistry {
    private final Map<String, Validator<DataAddress>> sourceValidators = new HashMap<String, Validator<DataAddress>>();
    private final Map<String, Validator<DataAddress>> destinationValidators = new HashMap<String, Validator<DataAddress>>();
    private final Monitor monitor;

    public DataAddressValidatorRegistryImpl(Monitor monitor) {
        this.monitor = monitor;
    }

    public void registerSourceValidator(String type, Validator<DataAddress> validator) {
        this.sourceValidators.put(type, validator);
    }

    public void registerDestinationValidator(String type, Validator<DataAddress> validator) {
        this.destinationValidators.put(type, validator);
    }

    public ValidationResult validateSource(DataAddress dataAddress) {
        return this.sourceValidators.getOrDefault(dataAddress.getType(), (Validator<DataAddress>)((Validator)d -> this.warning("source", dataAddress))).validate((Object)dataAddress);
    }

    public ValidationResult validateDestination(DataAddress dataAddress) {
        return this.destinationValidators.getOrDefault(dataAddress.getType(), (Validator<DataAddress>)((Validator)d -> this.warning("destination", dataAddress))).validate((Object)dataAddress);
    }

    @NotNull
    private ValidationResult warning(String type, DataAddress dataAddress) {
        this.monitor.warning("No %s DataAddress validator has been registered for type %s, please register one as it is strongly recommended.".formatted(type, dataAddress.getType()), new Throwable[0]);
        return ValidationResult.success();
    }
}

