/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane;

import java.time.Clock;
import org.eclipse.edc.connector.api.control.configuration.ControlApiConfiguration;
import org.eclipse.edc.connector.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.dataplane.spi.client.DataPlaneClient;
import org.eclipse.edc.connector.transfer.dataplane.api.ConsumerPullTransferTokenValidationApiController;
import org.eclipse.edc.connector.transfer.dataplane.flow.ConsumerPullTransferDataFlowController;
import org.eclipse.edc.connector.transfer.dataplane.flow.ProviderPushTransferDataFlowController;
import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullTransferEndpointDataReferenceServiceImpl;
import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullTransferProxyResolver;
import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullTransferProxyTransformer;
import org.eclipse.edc.connector.transfer.dataplane.spi.proxy.ConsumerPullTransferEndpointDataReferenceService;
import org.eclipse.edc.connector.transfer.dataplane.spi.security.DataEncrypter;
import org.eclipse.edc.connector.transfer.dataplane.spi.security.KeyPairWrapper;
import org.eclipse.edc.connector.transfer.dataplane.validation.ContractValidationRule;
import org.eclipse.edc.connector.transfer.dataplane.validation.ExpirationDateValidationRule;
import org.eclipse.edc.connector.transfer.spi.callback.ControlPlaneApiUrl;
import org.eclipse.edc.connector.transfer.spi.edr.EndpointDataReferenceTransformer;
import org.eclipse.edc.connector.transfer.spi.edr.EndpointDataReferenceTransformerRegistry;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowController;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowManager;
import org.eclipse.edc.jwt.TokenGenerationServiceImpl;
import org.eclipse.edc.jwt.TokenValidationRulesRegistryImpl;
import org.eclipse.edc.jwt.TokenValidationServiceImpl;
import org.eclipse.edc.jwt.spi.TokenGenerationService;
import org.eclipse.edc.jwt.spi.TokenValidationRule;
import org.eclipse.edc.jwt.spi.TokenValidationRulesRegistry;
import org.eclipse.edc.jwt.spi.TokenValidationService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.message.RemoteMessageDispatcherRegistry;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.configuration.Config;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Transfer Data Plane Core")
public class TransferDataPlaneCoreExtension
implements ServiceExtension {
    public static final String NAME = "Transfer Data Plane Core";
    @Deprecated(since="milestone8")
    private static final String DEPRECATED_API_CONTEXT_ALIAS = "validation";
    @Inject
    private ContractNegotiationStore contractNegotiationStore;
    @Inject
    private RemoteMessageDispatcherRegistry dispatcherRegistry;
    @Inject
    private WebService webService;
    @Inject
    private DataFlowManager dataFlowManager;
    @Inject
    private EndpointDataReferenceTransformerRegistry transformerRegistry;
    @Inject
    private Clock clock;
    @Inject
    private DataEncrypter dataEncrypter;
    @Inject
    private DataPlaneClient dataPlaneClient;
    @Inject
    private ControlApiConfiguration controlApiConfiguration;
    @Inject
    private KeyPairWrapper keyPairWrapper;
    @Inject
    private ConsumerPullTransferProxyResolver proxyResolver;
    @Inject(required=false)
    private ControlPlaneApiUrl callbackUrl;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        TokenValidationService tokenValidationService = this.createTokenValidationService();
        this.webService.registerResource(this.getApiContext(context), (Object)new ConsumerPullTransferTokenValidationApiController(tokenValidationService, this.dataEncrypter, this.typeManager));
        ConsumerPullTransferEndpointDataReferenceService proxyReferenceService = this.createDataProxyReferenceService(context.getConfig(), this.typeManager);
        this.dataFlowManager.register((DataFlowController)new ConsumerPullTransferDataFlowController(context.getConnectorId(), this.proxyResolver, proxyReferenceService, this.dispatcherRegistry));
        this.dataFlowManager.register((DataFlowController)new ProviderPushTransferDataFlowController(this.callbackUrl, this.dataPlaneClient));
        ConsumerPullTransferProxyTransformer consumerProxyTransformer = new ConsumerPullTransferProxyTransformer(this.proxyResolver, proxyReferenceService);
        this.transformerRegistry.registerTransformer((EndpointDataReferenceTransformer)consumerProxyTransformer);
    }

    private String getApiContext(ServiceExtensionContext context) {
        if (context.getConfig().hasPath("web.http.validation")) {
            context.getMonitor().warning(String.format("Deprecated settings group %s is being used for Control API configuration, please switch to the new group %s", "web.http.validation", "web.http.control"), new Throwable[0]);
            return DEPRECATED_API_CONTEXT_ALIAS;
        }
        return this.controlApiConfiguration.getContextAlias();
    }

    private ConsumerPullTransferEndpointDataReferenceService createDataProxyReferenceService(Config config, TypeManager typeManager) {
        Long tokenValiditySeconds = config.getLong("edc.transfer.proxy.token.validity.seconds", Long.valueOf(600L));
        TokenGenerationServiceImpl tokenGenerationService = new TokenGenerationServiceImpl(this.keyPairWrapper.get().getPrivate());
        return new ConsumerPullTransferEndpointDataReferenceServiceImpl((TokenGenerationService)tokenGenerationService, typeManager, tokenValiditySeconds, this.dataEncrypter, this.clock);
    }

    private TokenValidationService createTokenValidationService() {
        TokenValidationRulesRegistryImpl registry = new TokenValidationRulesRegistryImpl();
        registry.addRule((TokenValidationRule)new ContractValidationRule(this.contractNegotiationStore, this.clock));
        registry.addRule((TokenValidationRule)new ExpirationDateValidationRule(this.clock));
        return new TokenValidationServiceImpl(id -> this.keyPairWrapper.get().getPublic(), (TokenValidationRulesRegistry)registry);
    }
}

