/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.flow;

import java.util.concurrent.CompletableFuture;
import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullTransferProxyResolver;
import org.eclipse.edc.connector.transfer.dataplane.spi.proxy.ConsumerPullTransferEndpointDataReferenceCreationRequest;
import org.eclipse.edc.connector.transfer.dataplane.spi.proxy.ConsumerPullTransferEndpointDataReferenceService;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowController;
import org.eclipse.edc.connector.transfer.spi.types.DataRequest;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.message.RemoteMessageDispatcherRegistry;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReferenceMessage;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;
import org.jetbrains.annotations.NotNull;

public class ConsumerPullTransferDataFlowController
implements DataFlowController {
    private final String connectorId;
    private final ConsumerPullTransferProxyResolver proxyResolver;
    private final ConsumerPullTransferEndpointDataReferenceService proxyReferenceService;
    private final RemoteMessageDispatcherRegistry dispatcherRegistry;

    public ConsumerPullTransferDataFlowController(String connectorId, ConsumerPullTransferProxyResolver proxyResolver, ConsumerPullTransferEndpointDataReferenceService proxyReferenceService, RemoteMessageDispatcherRegistry dispatcherRegistry) {
        this.connectorId = connectorId;
        this.proxyResolver = proxyResolver;
        this.proxyReferenceService = proxyReferenceService;
        this.dispatcherRegistry = dispatcherRegistry;
    }

    public boolean canHandle(DataRequest dataRequest, DataAddress contentAddress) {
        return "HttpProxy".equals(dataRequest.getDestinationType());
    }

    @NotNull
    public StatusResult<Void> initiateFlow(DataRequest dataRequest, DataAddress contentAddress, Policy policy) {
        Result<String> proxyUrl = this.proxyResolver.resolveProxyUrl(contentAddress);
        if (proxyUrl.failed()) {
            return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)String.format("Failed to resolve proxy url for data request %s%n %s", dataRequest.getId(), proxyUrl.getFailureDetail()));
        }
        ConsumerPullTransferEndpointDataReferenceCreationRequest proxyCreationRequest = ConsumerPullTransferEndpointDataReferenceCreationRequest.Builder.newInstance().id(dataRequest.getId()).contentAddress(contentAddress).proxyEndpoint((String)proxyUrl.getContent()).contractId(dataRequest.getContractId()).build();
        Result proxyCreationResult = this.proxyReferenceService.createProxyReference(proxyCreationRequest);
        if (proxyCreationResult.failed()) {
            return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)("Failed to generate proxy: " + proxyCreationResult.getFailureDetail()));
        }
        return this.dispatch((EndpointDataReference)proxyCreationResult.getContent(), dataRequest);
    }

    private StatusResult<Void> dispatch(@NotNull EndpointDataReference edr, @NotNull DataRequest dataRequest) {
        EndpointDataReferenceMessage request = EndpointDataReferenceMessage.Builder.newInstance().connectorId(this.connectorId).connectorAddress(dataRequest.getConnectorAddress()).protocol(dataRequest.getProtocol()).endpointDataReference(edr).build();
        return (StatusResult)((CompletableFuture)((CompletableFuture)this.dispatcherRegistry.send(Object.class, (RemoteMessage)request, () -> ((DataRequest)dataRequest).getId()).thenApply(o -> StatusResult.success())).exceptionally(throwable -> StatusResult.failure((ResponseStatus)ResponseStatus.ERROR_RETRY, (String)("Transfer failed: " + throwable.getMessage())))).join();
    }
}

