/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.validation;

import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import org.eclipse.edc.connector.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.contract.spi.types.agreement.ContractAgreement;
import org.eclipse.edc.jwt.spi.TokenValidationRule;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.result.Result;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContractValidationRule
implements TokenValidationRule {
    private final ContractNegotiationStore contractNegotiationStore;
    private final Clock clock;

    public ContractValidationRule(ContractNegotiationStore contractNegotiationStore, Clock clock) {
        this.contractNegotiationStore = contractNegotiationStore;
        this.clock = clock;
    }

    public Result<Void> checkRule(@NotNull ClaimToken toVerify, @Nullable Map<String, Object> additional) {
        String contractId = toVerify.getStringClaim("cid");
        if (contractId == null) {
            return Result.failure((String)String.format("Missing contract id claim `%s`", "cid"));
        }
        ContractAgreement contractAgreement = this.contractNegotiationStore.findContractAgreement(contractId);
        if (contractAgreement == null) {
            return Result.failure((String)("No contract agreement found for id: " + contractId));
        }
        if (this.clock.instant().isAfter(Instant.ofEpochSecond(contractAgreement.getContractEndDate()))) {
            return Result.failure((String)"Contract has expired");
        }
        return Result.success();
    }
}

