/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.edc.connector.transfer.dataplane.security.ConsumerPullTransferKeyPair;
import org.eclipse.edc.connector.transfer.dataplane.security.PublicKeyParser;
import org.eclipse.edc.connector.transfer.dataplane.spi.security.KeyPairWrapper;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.security.PrivateKeyResolver;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.jetbrains.annotations.NotNull;

@Extension(value="Consumer Pull Transfer Proxy Resolver")
public class ConsumerPullTransferKeyPairExtension
implements ServiceExtension {
    public static final String NAME = "Consumer Pull Transfer Key Pair";
    @Inject(required=false)
    private PrivateKeyResolver privateKeyResolver;
    @Inject(required=false)
    private Vault vault;

    public String name() {
        return NAME;
    }

    @Provider
    public KeyPairWrapper keyPairWrapper(ServiceExtensionContext context) {
        String pubKeyAlias = context.getSetting("edc.transfer.proxy.token.verifier.publickey.alias", null);
        String privKeyAlias = context.getSetting("edc.transfer.proxy.token.signer.privatekey.alias", null);
        if (pubKeyAlias == null && privKeyAlias == null) {
            context.getMonitor().info(() -> "Either private (n)or public key alias not provided for 'consumer pull' transfer, a random key pair will be generated", new Throwable[0]);
            return new ConsumerPullTransferKeyPair(ConsumerPullTransferKeyPairExtension.randomKeyPair());
        }
        Objects.requireNonNull(this.privateKeyResolver, "private key resolver");
        Objects.requireNonNull(this.vault, "vault");
        Objects.requireNonNull(pubKeyAlias, "public key alias");
        Objects.requireNonNull(privKeyAlias, "private key alias");
        PublicKey publicKey = this.getPublicKey(pubKeyAlias);
        PrivateKey privateKey = this.getPrivateKey(privKeyAlias);
        return new ConsumerPullTransferKeyPair(new KeyPair(publicKey, privateKey));
    }

    @NotNull
    private PublicKey getPublicKey(String alias) {
        String publicKeyPem = this.vault.resolveSecret(alias);
        Objects.requireNonNull(publicKeyPem, "Failed to resolve public key with alias: " + alias + " from vault");
        return PublicKeyParser.from(publicKeyPem);
    }

    @NotNull
    private PrivateKey getPrivateKey(String alias) {
        PrivateKey privateKey = (PrivateKey)this.privateKeyResolver.resolvePrivateKey(alias, PrivateKey.class);
        Objects.requireNonNull(privateKey, "Failed to resolve private key with alias: " + alias);
        return privateKey;
    }

    private static KeyPair randomKeyPair() {
        try {
            return ((ECKey)new ECKeyGenerator(Curve.P_256).keyUse(KeyUse.SIGNATURE).keyID(UUID.randomUUID().toString()).generate()).toKeyPair();
        }
        catch (JOSEException e) {
            throw new EdcException((Throwable)e);
        }
    }
}

