/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.flow;

import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullTransferProxyResolver;
import org.eclipse.edc.connector.transfer.dataplane.spi.proxy.ConsumerPullTransferEndpointDataReferenceCreationRequest;
import org.eclipse.edc.connector.transfer.dataplane.spi.proxy.ConsumerPullTransferEndpointDataReferenceService;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowController;
import org.eclipse.edc.connector.transfer.spi.types.DataFlowResponse;
import org.eclipse.edc.connector.transfer.spi.types.DataRequest;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataAddressConstants;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.jetbrains.annotations.NotNull;

public class ConsumerPullTransferDataFlowController
implements DataFlowController {
    private final ConsumerPullTransferProxyResolver proxyResolver;
    private final ConsumerPullTransferEndpointDataReferenceService proxyReferenceService;

    public ConsumerPullTransferDataFlowController(ConsumerPullTransferProxyResolver proxyResolver, ConsumerPullTransferEndpointDataReferenceService proxyReferenceService) {
        this.proxyResolver = proxyResolver;
        this.proxyReferenceService = proxyReferenceService;
    }

    public boolean canHandle(DataRequest dataRequest, DataAddress contentAddress) {
        return "HttpProxy".equals(dataRequest.getDestinationType());
    }

    @NotNull
    public StatusResult<DataFlowResponse> initiateFlow(DataRequest dataRequest, DataAddress contentAddress, Policy policy) {
        Result<String> proxyUrl = this.proxyResolver.resolveProxyUrl(contentAddress);
        if (proxyUrl.failed()) {
            return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)String.format("Failed to resolve proxy url for data request %s%n %s", dataRequest.getId(), proxyUrl.getFailureDetail()));
        }
        ConsumerPullTransferEndpointDataReferenceCreationRequest proxyCreationRequest = ConsumerPullTransferEndpointDataReferenceCreationRequest.Builder.newInstance().id(dataRequest.getId()).contentAddress(contentAddress).proxyEndpoint((String)proxyUrl.getContent()).contractId(dataRequest.getContractId()).build();
        return (StatusResult)this.proxyReferenceService.createProxyReference(proxyCreationRequest).map(this::createResponse).map(StatusResult::success).orElse(failure -> StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)("Failed to generate proxy: " + failure.getFailureDetail())));
    }

    private DataFlowResponse createResponse(EndpointDataReference edr) {
        return DataFlowResponse.Builder.newInstance().dataAddress(EndpointDataAddressConstants.from((EndpointDataReference)edr)).build();
    }
}

