/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.proxy;

import org.eclipse.edc.connector.dataplane.selector.spi.client.DataPlaneSelectorClient;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullTransferProxyResolver;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.DataAddress;

public class ConsumerPullTransferProxyResolverImpl
implements ConsumerPullTransferProxyResolver {
    private static final String PUBLIC_API_URL_PROPERTY = "publicApiUrl";
    private final DataPlaneSelectorClient selectorClient;
    private final String selectorStrategy;

    public ConsumerPullTransferProxyResolverImpl(DataPlaneSelectorClient selectorClient, String selectorStrategy) {
        this.selectorClient = selectorClient;
        this.selectorStrategy = selectorStrategy;
    }

    @Override
    public Result<String> resolveProxyUrl(DataAddress source) {
        DataPlaneInstance dataPlaneInstance = this.selectorClient.find(source, ConsumerPullTransferProxyResolverImpl.destinationAddress(), this.selectorStrategy);
        if (dataPlaneInstance == null) {
            return Result.failure((String)("Failed to find DataPlaneInstance for proxying data from source: " + source.getType()));
        }
        Object publicApiUrl = dataPlaneInstance.getProperties().get(PUBLIC_API_URL_PROPERTY);
        if (publicApiUrl == null) {
            return Result.failure((String)String.format("Missing property `%s` in DataPlaneInstance", PUBLIC_API_URL_PROPERTY));
        }
        return Result.success((Object)publicApiUrl.toString());
    }

    private static DataAddress destinationAddress() {
        return DataAddress.Builder.newInstance().type("HttpProxy").build();
    }
}

