/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.flow;

import java.util.UUID;
import org.eclipse.edc.connector.dataplane.spi.client.DataPlaneClient;
import org.eclipse.edc.connector.transfer.spi.callback.ControlPlaneApiUrl;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowController;
import org.eclipse.edc.connector.transfer.spi.types.DataFlowResponse;
import org.eclipse.edc.connector.transfer.spi.types.DataRequest;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;
import org.jetbrains.annotations.NotNull;

public class ProviderPushTransferDataFlowController
implements DataFlowController {
    private final ControlPlaneApiUrl callbackUrl;
    private final DataPlaneClient dataPlaneClient;

    public ProviderPushTransferDataFlowController(ControlPlaneApiUrl callbackUrl, DataPlaneClient dataPlaneClient) {
        this.callbackUrl = callbackUrl;
        this.dataPlaneClient = dataPlaneClient;
    }

    public boolean canHandle(DataRequest dataRequest, DataAddress contentAddress) {
        return !"HttpProxy".equals(dataRequest.getDestinationType());
    }

    @NotNull
    public StatusResult<DataFlowResponse> initiateFlow(DataRequest dataRequest, DataAddress contentAddress, Policy policy) {
        DataFlowRequest dataFlowRequest = this.createRequest(dataRequest, contentAddress);
        StatusResult result = this.dataPlaneClient.transfer(dataFlowRequest);
        if (result.failed()) {
            return StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)("Failed to delegate data transfer to Data Plane: " + result.getFailureDetail()));
        }
        return StatusResult.success((Object)DataFlowResponse.Builder.newInstance().build());
    }

    private DataFlowRequest createRequest(DataRequest dataRequest, DataAddress sourceAddress) {
        return DataFlowRequest.Builder.newInstance().id(UUID.randomUUID().toString()).processId(dataRequest.getProcessId()).trackable(true).sourceDataAddress(sourceAddress).destinationType(dataRequest.getDestinationType()).destinationDataAddress(dataRequest.getDataDestination()).callbackAddress(this.callbackUrl != null ? this.callbackUrl.get() : null).properties(dataRequest.getProperties()).build();
    }
}

