/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.proxy;

import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullTransferProxyResolver;
import org.eclipse.edc.connector.transfer.dataplane.spi.proxy.ConsumerPullTransferEndpointDataReferenceCreationRequest;
import org.eclipse.edc.connector.transfer.dataplane.spi.proxy.ConsumerPullTransferEndpointDataReferenceService;
import org.eclipse.edc.connector.transfer.spi.edr.EndpointDataReferenceTransformer;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.HttpDataAddress;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.jetbrains.annotations.NotNull;

public class ConsumerPullTransferProxyTransformer
implements EndpointDataReferenceTransformer {
    private final ConsumerPullTransferProxyResolver proxyResolver;
    private final ConsumerPullTransferEndpointDataReferenceService proxyReferenceCreator;

    public ConsumerPullTransferProxyTransformer(ConsumerPullTransferProxyResolver proxyResolver, ConsumerPullTransferEndpointDataReferenceService proxyCreator) {
        this.proxyResolver = proxyResolver;
        this.proxyReferenceCreator = proxyCreator;
    }

    private static DataAddress toHttpDataAddress(EndpointDataReference edr) {
        return HttpDataAddress.Builder.newInstance().baseUrl(edr.getEndpoint()).authKey(edr.getAuthKey()).authCode(edr.getAuthCode()).proxyBody(Boolean.TRUE.toString()).proxyPath(Boolean.TRUE.toString()).proxyMethod(Boolean.TRUE.toString()).proxyQueryParams(Boolean.TRUE.toString()).build();
    }

    public boolean canHandle(@NotNull EndpointDataReference edr) {
        return true;
    }

    public Result<EndpointDataReference> transform(@NotNull EndpointDataReference edr) {
        DataAddress address = ConsumerPullTransferProxyTransformer.toHttpDataAddress(edr);
        String contractId = (String)edr.getProperties().get("https://w3id.org/edc/v0.0.1/ns/cid");
        if (contractId == null) {
            return Result.failure((String)String.format("Cannot transform endpoint data reference with id %s as contract id is missing", edr.getId()));
        }
        Result<String> proxyUrl = this.proxyResolver.resolveProxyUrl(address);
        if (proxyUrl.failed()) {
            return Result.failure((String)String.format("Failed to resolve proxy url for endpoint data reference %s\n %s", edr.getId(), String.join((CharSequence)",", proxyUrl.getFailureMessages())));
        }
        ConsumerPullTransferEndpointDataReferenceCreationRequest.Builder builder = ConsumerPullTransferEndpointDataReferenceCreationRequest.Builder.newInstance().id(edr.getId()).contentAddress(address).proxyEndpoint((String)proxyUrl.getContent()).contractId(contractId);
        edr.getProperties().forEach((arg_0, arg_1) -> ((ConsumerPullTransferEndpointDataReferenceCreationRequest.Builder)builder).property(arg_0, arg_1));
        return this.proxyReferenceCreator.createProxyReference(builder.build());
    }
}

