/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.proxy;

import java.time.Clock;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullTransferTokenDecorator;
import org.eclipse.edc.connector.transfer.dataplane.spi.proxy.ConsumerPullTransferEndpointDataReferenceCreationRequest;
import org.eclipse.edc.connector.transfer.dataplane.spi.proxy.ConsumerPullTransferEndpointDataReferenceService;
import org.eclipse.edc.connector.transfer.dataplane.spi.security.DataEncrypter;
import org.eclipse.edc.jwt.spi.JwtDecorator;
import org.eclipse.edc.jwt.spi.TokenGenerationService;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.jetbrains.annotations.NotNull;

public class ConsumerPullTransferEndpointDataReferenceServiceImpl
implements ConsumerPullTransferEndpointDataReferenceService {
    private final TokenGenerationService tokenGenerationService;
    private final TypeManager typeManager;
    private final long tokenValiditySeconds;
    private final DataEncrypter dataEncrypter;
    private final Clock clock;

    public ConsumerPullTransferEndpointDataReferenceServiceImpl(TokenGenerationService tokenGenerationService, TypeManager typeManager, long tokenValiditySeconds, DataEncrypter dataEncrypter, Clock clock) {
        this.tokenGenerationService = tokenGenerationService;
        this.typeManager = typeManager;
        this.tokenValiditySeconds = tokenValiditySeconds;
        this.dataEncrypter = dataEncrypter;
        this.clock = clock;
    }

    public Result<EndpointDataReference> createProxyReference(@NotNull ConsumerPullTransferEndpointDataReferenceCreationRequest request) {
        String encryptedDataAddress = this.dataEncrypter.encrypt(this.typeManager.writeValueAsString((Object)request.getContentAddress()));
        ConsumerPullTransferTokenDecorator decorator = new ConsumerPullTransferTokenDecorator(Date.from(this.clock.instant().plusSeconds(this.tokenValiditySeconds)), request.getContractId(), encryptedDataAddress);
        Result tokenGenerationResult = this.tokenGenerationService.generate(new JwtDecorator[]{decorator});
        if (tokenGenerationResult.failed()) {
            return Result.failure((List)tokenGenerationResult.getFailureMessages());
        }
        HashMap<String, String> props = new HashMap<String, String>(request.getProperties());
        props.put("https://w3id.org/edc/v0.0.1/ns/cid", request.getContractId());
        EndpointDataReference.Builder builder = EndpointDataReference.Builder.newInstance().id(request.getId()).endpoint(request.getProxyEndpoint()).authKey("Authorization").authCode(((TokenRepresentation)tokenGenerationResult.getContent()).getToken()).properties(props);
        return Result.success((Object)builder.build());
    }
}

