/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.PublicKey;
import org.eclipse.edc.spi.EdcException;
import org.jetbrains.annotations.NotNull;

public class PublicKeyParser {
    private PublicKeyParser() {
    }

    public static PublicKey from(@NotNull String pem) {
        try {
            JWK jwk = JWK.parseFromPEMEncodedObjects((String)pem);
            if (jwk instanceof RSAKey) {
                return jwk.toRSAKey().toPublicKey();
            }
            if (jwk instanceof ECKey) {
                return jwk.toECKey().toPublicKey();
            }
            throw new EdcException(String.join((CharSequence)"Public key algorithm %s is not supported", jwk.getAlgorithm().toString()));
        }
        catch (JOSEException e) {
            throw new EdcException((Throwable)e);
        }
    }
}

