/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.proxy;

import java.util.Date;
import java.util.Optional;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullDataPlaneProxyTokenDecorator;
import org.eclipse.edc.connector.transfer.dataplane.spi.security.DataEncrypter;
import org.eclipse.edc.connector.transfer.dataplane.spi.token.ConsumerPullTokenExpirationDateFunction;
import org.eclipse.edc.connector.transfer.spi.types.DataRequest;
import org.eclipse.edc.jwt.spi.JwtDecorator;
import org.eclipse.edc.jwt.spi.TokenGenerationService;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.DataAddress;

public class ConsumerPullDataPlaneProxyResolver {
    private static final String PUBLIC_API_URL_PROPERTY = "publicApiUrl";
    private final DataEncrypter dataEncrypter;
    private final TypeManager typeManager;
    private final TokenGenerationService tokenGenerationService;
    private final ConsumerPullTokenExpirationDateFunction tokenExpirationDateFunction;

    public ConsumerPullDataPlaneProxyResolver(DataEncrypter dataEncrypter, TypeManager typeManager, TokenGenerationService tokenGenerationService, ConsumerPullTokenExpirationDateFunction tokenExpirationDateFunction) {
        this.dataEncrypter = dataEncrypter;
        this.typeManager = typeManager;
        this.tokenExpirationDateFunction = tokenExpirationDateFunction;
        this.tokenGenerationService = tokenGenerationService;
    }

    public Result<DataAddress> toDataAddress(DataRequest request, DataAddress address, DataPlaneInstance instance) {
        return (Result)this.resolveProxyUrl(instance).compose(proxyUrl -> (Result)this.generateAccessToken(address, request.getContractId()).map(token -> DataAddress.Builder.newInstance().type("EDR").property("https://w3id.org/edc/v0.0.1/ns/id", request.getId()).property("https://w3id.org/edc/v0.0.1/ns/endpoint", proxyUrl).property("https://w3id.org/edc/v0.0.1/ns/authKey", "Authorization").property("https://w3id.org/edc/v0.0.1/ns/authCode", token).build()));
    }

    private Result<String> resolveProxyUrl(DataPlaneInstance instance) {
        return Optional.ofNullable(instance.getProperties().get(PUBLIC_API_URL_PROPERTY)).map(url -> Result.success((Object)((String)url))).orElse(Result.failure((String)String.format("Missing property `%s` in DataPlaneInstance", PUBLIC_API_URL_PROPERTY)));
    }

    private Result<String> generateAccessToken(DataAddress source, String contractId) {
        String encryptedDataAddress = this.dataEncrypter.encrypt(this.typeManager.writeValueAsString((Object)source));
        return (Result)((Result)this.tokenExpirationDateFunction.expiresAt(source, contractId).compose(expiration -> this.tokenGenerationService.generate(new JwtDecorator[]{new ConsumerPullDataPlaneProxyTokenDecorator((Date)expiration, contractId, encryptedDataAddress)}))).map(TokenRepresentation::getToken);
    }
}

