/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane;

import java.security.KeyPair;
import java.security.PublicKey;
import java.time.Clock;
import java.util.Objects;
import org.eclipse.edc.connector.api.control.configuration.ControlApiConfiguration;
import org.eclipse.edc.connector.contract.spi.negotiation.store.ContractNegotiationStore;
import org.eclipse.edc.connector.dataplane.selector.spi.client.DataPlaneSelectorClient;
import org.eclipse.edc.connector.dataplane.spi.client.DataPlaneClient;
import org.eclipse.edc.connector.transfer.dataplane.api.ConsumerPullTransferTokenValidationApiController;
import org.eclipse.edc.connector.transfer.dataplane.flow.ConsumerPullTransferDataFlowController;
import org.eclipse.edc.connector.transfer.dataplane.flow.ProviderPushTransferDataFlowController;
import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullDataPlaneProxyResolver;
import org.eclipse.edc.connector.transfer.dataplane.security.ConsumerPullKeyPairFactory;
import org.eclipse.edc.connector.transfer.dataplane.spi.security.DataEncrypter;
import org.eclipse.edc.connector.transfer.dataplane.spi.token.ConsumerPullTokenExpirationDateFunction;
import org.eclipse.edc.connector.transfer.dataplane.validation.ContractValidationRule;
import org.eclipse.edc.connector.transfer.dataplane.validation.ExpirationDateValidationRule;
import org.eclipse.edc.connector.transfer.spi.callback.ControlApiUrl;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowController;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowManager;
import org.eclipse.edc.jwt.TokenGenerationServiceImpl;
import org.eclipse.edc.jwt.TokenValidationRulesRegistryImpl;
import org.eclipse.edc.jwt.TokenValidationServiceImpl;
import org.eclipse.edc.jwt.spi.TokenGenerationService;
import org.eclipse.edc.jwt.spi.TokenValidationRule;
import org.eclipse.edc.jwt.spi.TokenValidationRulesRegistry;
import org.eclipse.edc.jwt.spi.TokenValidationService;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.security.PrivateKeyResolver;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.web.spi.WebService;

@Extension(value="Transfer Data Plane Core")
public class TransferDataPlaneCoreExtension
implements ServiceExtension {
    public static final String NAME = "Transfer Data Plane Core";
    @Inject
    private ContractNegotiationStore contractNegotiationStore;
    @Inject
    private Vault vault;
    @Inject
    private PrivateKeyResolver privateKeyResolver;
    @Inject
    private WebService webService;
    @Inject
    private DataFlowManager dataFlowManager;
    @Inject
    private Clock clock;
    @Inject
    private DataEncrypter dataEncrypter;
    @Inject
    private DataPlaneClient dataPlaneClient;
    @Inject
    private ControlApiConfiguration controlApiConfiguration;
    @Inject
    private DataPlaneSelectorClient selectorClient;
    @Inject
    private ConsumerPullTokenExpirationDateFunction tokenExpirationDateFunction;
    @Inject(required=false)
    private ControlApiUrl callbackUrl;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        KeyPair keyPair = this.keyPairFromConfig(context);
        ConsumerPullTransferTokenValidationApiController controller = new ConsumerPullTransferTokenValidationApiController(this.tokenValidationService(keyPair.getPublic()), this.dataEncrypter, this.typeManager);
        this.webService.registerResource(this.controlApiConfiguration.getContextAlias(), (Object)controller);
        ConsumerPullDataPlaneProxyResolver resolver = new ConsumerPullDataPlaneProxyResolver(this.dataEncrypter, this.typeManager, (TokenGenerationService)new TokenGenerationServiceImpl(keyPair.getPrivate()), this.tokenExpirationDateFunction);
        this.dataFlowManager.register((DataFlowController)new ConsumerPullTransferDataFlowController(this.selectorClient, resolver));
        this.dataFlowManager.register((DataFlowController)new ProviderPushTransferDataFlowController(this.callbackUrl, this.dataPlaneClient));
    }

    private KeyPair keyPairFromConfig(ServiceExtensionContext context) {
        ConsumerPullKeyPairFactory keyPairFactory = new ConsumerPullKeyPairFactory(this.privateKeyResolver, this.vault);
        String pubKeyAlias = context.getSetting("edc.transfer.proxy.token.verifier.publickey.alias", null);
        String privKeyAlias = context.getSetting("edc.transfer.proxy.token.signer.privatekey.alias", null);
        if (pubKeyAlias == null && privKeyAlias == null) {
            context.getMonitor().info(() -> "No public or private key provided for 'Consumer Pull' transfers -> a key pair will be generated (DO NOT USE IN PRODUCTION)", new Throwable[0]);
            return keyPairFactory.defaultKeyPair();
        }
        Objects.requireNonNull(pubKeyAlias, "public key alias");
        Objects.requireNonNull(privKeyAlias, "private key alias");
        return (KeyPair)keyPairFactory.fromConfig(pubKeyAlias, privKeyAlias).orElseThrow(failure -> new EdcException(failure.getFailureDetail()));
    }

    private TokenValidationService tokenValidationService(PublicKey publicKey) {
        TokenValidationRulesRegistryImpl registry = new TokenValidationRulesRegistryImpl();
        registry.addRule((TokenValidationRule)new ContractValidationRule(this.contractNegotiationStore, this.clock));
        registry.addRule((TokenValidationRule)new ExpirationDateValidationRule(this.clock));
        return new TokenValidationServiceImpl(id -> publicKey, (TokenValidationRulesRegistry)registry);
    }
}

