/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.flow;

import java.util.UUID;
import org.eclipse.edc.connector.dataplane.spi.client.DataPlaneClient;
import org.eclipse.edc.connector.transfer.spi.callback.ControlApiUrl;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowController;
import org.eclipse.edc.connector.transfer.spi.types.DataFlowResponse;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcess;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;
import org.jetbrains.annotations.NotNull;

public class ProviderPushTransferDataFlowController
implements DataFlowController {
    private final ControlApiUrl callbackUrl;
    private final DataPlaneClient dataPlaneClient;

    public ProviderPushTransferDataFlowController(ControlApiUrl callbackUrl, DataPlaneClient dataPlaneClient) {
        this.callbackUrl = callbackUrl;
        this.dataPlaneClient = dataPlaneClient;
    }

    public boolean canHandle(TransferProcess transferProcess) {
        return !"HttpProxy".equals(transferProcess.getDestinationType());
    }

    @NotNull
    public StatusResult<DataFlowResponse> initiateFlow(TransferProcess transferProcess, Policy policy) {
        DataFlowRequest dataFlowRequest = DataFlowRequest.Builder.newInstance().id(UUID.randomUUID().toString()).processId(transferProcess.getId()).trackable(true).sourceDataAddress(transferProcess.getContentDataAddress()).destinationDataAddress(transferProcess.getDataDestination()).callbackAddress(this.callbackUrl != null ? this.callbackUrl.get() : null).build();
        return (StatusResult)this.dataPlaneClient.transfer(dataFlowRequest).map(it -> DataFlowResponse.Builder.newInstance().build());
    }
}

