/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.security.PrivateKeyResolver;
import org.eclipse.edc.spi.security.Vault;
import org.jetbrains.annotations.NotNull;

public class ConsumerPullKeyPairFactory {
    private final PrivateKeyResolver privateKeyResolver;
    private final Vault vault;

    public ConsumerPullKeyPairFactory(PrivateKeyResolver privateKeyResolver, Vault vault) {
        this.privateKeyResolver = privateKeyResolver;
        this.vault = vault;
    }

    public Result<KeyPair> fromConfig(@NotNull String publicKeyAlias, @NotNull String privateKeyAlias) {
        return (Result)this.publicKey(publicKeyAlias).compose(publicKey -> (Result)this.privateKey(privateKeyAlias).map(privateKey -> new KeyPair((PublicKey)publicKey, (PrivateKey)privateKey)));
    }

    public KeyPair defaultKeyPair() {
        try {
            return ((ECKey)new ECKeyGenerator(Curve.P_256).keyUse(KeyUse.SIGNATURE).keyID(UUID.randomUUID().toString()).generate()).toKeyPair();
        }
        catch (JOSEException e) {
            throw new EdcException((Throwable)e);
        }
    }

    @NotNull
    private Result<PublicKey> publicKey(String alias) {
        return Optional.ofNullable(this.vault.resolveSecret(alias)).map(ConsumerPullKeyPairFactory::convertPemToPublicKey).orElse(Result.failure((String)("Failed to resolve public key with alias: " + alias)));
    }

    @NotNull
    private Result<PrivateKey> privateKey(String alias) {
        return Optional.ofNullable((PrivateKey)this.privateKeyResolver.resolvePrivateKey(alias, PrivateKey.class)).map(Result::success).orElse(Result.failure((String)("Failed to resolve private key with alias: " + alias)));
    }

    @NotNull
    private static Result<PublicKey> convertPemToPublicKey(String pem) {
        try {
            JWK jwk = JWK.parseFromPEMEncodedObjects((String)pem);
            if (jwk instanceof RSAKey) {
                return Result.success((Object)jwk.toRSAKey().toPublicKey());
            }
            if (jwk instanceof ECKey) {
                return Result.success((Object)jwk.toECKey().toPublicKey());
            }
            return Result.failure((String)String.format("Public key algorithm %s is not supported", jwk.getAlgorithm().toString()));
        }
        catch (JOSEException e) {
            return Result.failure((String)("Failed to parse private key: " + e.getMessage()));
        }
    }
}

