/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.flow;

import java.util.Optional;
import org.eclipse.edc.connector.dataplane.selector.spi.client.DataPlaneSelectorClient;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullDataPlaneProxyResolver;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowController;
import org.eclipse.edc.connector.transfer.spi.types.DataFlowResponse;
import org.eclipse.edc.connector.transfer.spi.types.DataRequest;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcess;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.jetbrains.annotations.NotNull;

public class ConsumerPullTransferDataFlowController
implements DataFlowController {
    private final DataPlaneSelectorClient selectorClient;
    private final ConsumerPullDataPlaneProxyResolver resolver;

    public ConsumerPullTransferDataFlowController(DataPlaneSelectorClient selectorClient, ConsumerPullDataPlaneProxyResolver resolver) {
        this.selectorClient = selectorClient;
        this.resolver = resolver;
    }

    public boolean canHandle(TransferProcess transferProcess) {
        return "HttpProxy".equals(transferProcess.getDestinationType());
    }

    @NotNull
    public StatusResult<DataFlowResponse> initiateFlow(TransferProcess transferProcess, Policy policy) {
        DataAddress contentAddress = transferProcess.getContentDataAddress();
        DataRequest dataRequest = transferProcess.getDataRequest();
        return Optional.ofNullable(this.selectorClient.find(contentAddress, dataRequest.getDataDestination())).map(instance -> (StatusResult)this.resolver.toDataAddress(dataRequest, contentAddress, (DataPlaneInstance)instance).map(this::toResponse).map(StatusResult::success).orElse(failure -> StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)("Failed to generate proxy: " + failure.getFailureDetail())))).orElse(StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)String.format("Failed to find DataPlaneInstance for source/destination: %s/%s", contentAddress.getType(), "HttpProxy")));
    }

    public StatusResult<Void> terminate(TransferProcess transferProcess) {
        return StatusResult.success();
    }

    private DataFlowResponse toResponse(DataAddress address) {
        return DataFlowResponse.Builder.newInstance().dataAddress(address).build();
    }
}

