/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane;

import java.security.PrivateKey;
import java.time.Clock;
import java.util.function.Supplier;
import org.eclipse.edc.connector.api.control.configuration.ControlApiConfiguration;
import org.eclipse.edc.connector.dataplane.selector.spi.DataPlaneSelectorService;
import org.eclipse.edc.connector.dataplane.selector.spi.client.DataPlaneClientFactory;
import org.eclipse.edc.connector.transfer.dataplane.api.ConsumerPullTransferTokenValidationApiController;
import org.eclipse.edc.connector.transfer.dataplane.flow.ConsumerPullTransferDataFlowController;
import org.eclipse.edc.connector.transfer.dataplane.flow.ProviderPushTransferDataFlowController;
import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullDataPlaneProxyResolver;
import org.eclipse.edc.connector.transfer.dataplane.spi.security.DataEncrypter;
import org.eclipse.edc.connector.transfer.dataplane.spi.token.ConsumerPullTokenExpirationDateFunction;
import org.eclipse.edc.connector.transfer.dataplane.validation.ExpirationDateValidationRule;
import org.eclipse.edc.connector.transfer.spi.callback.ControlApiUrl;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowController;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowManager;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.iam.PublicKeyResolver;
import org.eclipse.edc.spi.security.PrivateKeyResolver;
import org.eclipse.edc.spi.security.Vault;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.token.JwtGenerationService;
import org.eclipse.edc.token.spi.TokenGenerationService;
import org.eclipse.edc.token.spi.TokenValidationRule;
import org.eclipse.edc.token.spi.TokenValidationRulesRegistry;
import org.eclipse.edc.token.spi.TokenValidationService;
import org.eclipse.edc.validator.spi.DataAddressValidatorRegistry;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.web.spi.WebService;
import org.jetbrains.annotations.NotNull;

@Extension(value="Transfer Data Plane Core")
public class TransferDataPlaneCoreExtension
implements ServiceExtension {
    public static final String NAME = "Transfer Data Plane Core";
    public static final String TRANSFER_DATAPLANE_TOKEN_CONTEXT = "dataplane-transfer";
    @Inject
    private Vault vault;
    @Inject
    private WebService webService;
    @Inject
    private DataFlowManager dataFlowManager;
    @Inject
    private Clock clock;
    @Inject
    private DataEncrypter dataEncrypter;
    @Inject
    private ControlApiConfiguration controlApiConfiguration;
    @Inject
    private DataPlaneSelectorService selectorService;
    @Inject
    private DataPlaneClientFactory clientFactory;
    @Inject
    private ConsumerPullTokenExpirationDateFunction tokenExpirationDateFunction;
    @Inject(required=false)
    private ControlApiUrl callbackUrl;
    @Inject
    private TypeManager typeManager;
    @Inject
    private PublicKeyResolver publicKeyResolver;
    @Inject
    private PrivateKeyResolver privateKeyResolver;
    @Inject
    private DataAddressValidatorRegistry dataAddressValidatorRegistry;
    @Inject
    private TokenValidationRulesRegistry tokenValidationRulesRegistry;
    @Inject
    private TokenValidationService tokenValidationService;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        String pubKeyAlias = context.getSetting("edc.transfer.proxy.token.verifier.publickey.alias", null);
        String privKeyAlias = context.getSetting("edc.transfer.proxy.token.signer.privatekey.alias", null);
        this.tokenValidationRulesRegistry.addRule(TRANSFER_DATAPLANE_TOKEN_CONTEXT, (TokenValidationRule)new ExpirationDateValidationRule(this.clock));
        ConsumerPullTransferTokenValidationApiController controller = new ConsumerPullTransferTokenValidationApiController(this.tokenValidationService, this.dataEncrypter, this.typeManager, this.publicKeyResolver);
        this.webService.registerResource(this.controlApiConfiguration.getContextAlias(), (Object)controller);
        ConsumerPullDataPlaneProxyResolver resolver = new ConsumerPullDataPlaneProxyResolver(this.dataEncrypter, this.typeManager, (TokenGenerationService)new JwtGenerationService(), this.getPrivateKeySupplier(context, privKeyAlias), () -> pubKeyAlias, this.tokenExpirationDateFunction);
        this.dataFlowManager.register((DataFlowController)new ConsumerPullTransferDataFlowController(this.selectorService, resolver));
        this.dataFlowManager.register((DataFlowController)new ProviderPushTransferDataFlowController(this.callbackUrl, this.selectorService, this.clientFactory));
        this.dataAddressValidatorRegistry.registerDestinationValidator("HttpProxy", dataAddress -> ValidationResult.success());
    }

    @NotNull
    private Supplier<PrivateKey> getPrivateKeySupplier(ServiceExtensionContext context, String privKeyAlias) {
        return () -> (PrivateKey)this.privateKeyResolver.resolvePrivateKey(privKeyAlias).orElse(f -> {
            context.getMonitor().warning(f.getFailureDetail(), new Throwable[0]);
            return null;
        });
    }
}

