/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.flow;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.edc.connector.dataplane.selector.spi.DataPlaneSelectorService;
import org.eclipse.edc.connector.dataplane.selector.spi.client.DataPlaneClientFactory;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.connector.transfer.spi.callback.ControlApiUrl;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowController;
import org.eclipse.edc.connector.transfer.spi.flow.FlowType;
import org.eclipse.edc.connector.transfer.spi.types.DataFlowResponse;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcess;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.asset.Asset;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowRequest;
import org.jetbrains.annotations.NotNull;

public class ProviderPushTransferDataFlowController
implements DataFlowController {
    private final ControlApiUrl callbackUrl;
    private final DataPlaneSelectorService selectorClient;
    private final DataPlaneClientFactory clientFactory;
    private final Set<String> transferTypes = Set.of("%s-%s".formatted("HttpData", FlowType.PULL));

    public ProviderPushTransferDataFlowController(ControlApiUrl callbackUrl, DataPlaneSelectorService selectorClient, DataPlaneClientFactory clientFactory) {
        this.callbackUrl = callbackUrl;
        this.selectorClient = selectorClient;
        this.clientFactory = clientFactory;
    }

    public boolean canHandle(TransferProcess transferProcess) {
        return !"HttpProxy".equals(transferProcess.getDestinationType()) && Optional.ofNullable(transferProcess.getTransferType()).map(type -> !this.transferTypes.contains(type)).orElse(true) != false;
    }

    @NotNull
    public StatusResult<DataFlowResponse> initiateFlow(TransferProcess transferProcess, Policy policy) {
        DataFlowRequest dataFlowRequest = DataFlowRequest.Builder.newInstance().id(UUID.randomUUID().toString()).processId(transferProcess.getId()).trackable(true).sourceDataAddress(transferProcess.getContentDataAddress()).destinationDataAddress(transferProcess.getDataDestination()).transferType(transferProcess.getTransferType()).callbackAddress(this.callbackUrl != null ? this.callbackUrl.get() : null).build();
        DataPlaneInstance dataPlaneInstance = this.selectorClient.select(transferProcess.getContentDataAddress(), transferProcess.getDataDestination());
        return (StatusResult)this.clientFactory.createClient(dataPlaneInstance).transfer(dataFlowRequest).map(it -> DataFlowResponse.Builder.newInstance().build());
    }

    public StatusResult<Void> terminate(TransferProcess transferProcess) {
        return this.selectorClient.getAll().stream().map(arg_0 -> ((DataPlaneClientFactory)this.clientFactory).createClient(arg_0)).map(client -> client.terminate(transferProcess.getId())).reduce(StatusResult::merge).orElse(StatusResult.success());
    }

    public Set<String> transferTypesFor(Asset asset) {
        return this.selectorClient.getAll().stream().filter(it -> it.getAllowedSourceTypes().contains(asset.getDataAddress().getType())).map(DataPlaneInstance::getAllowedDestTypes).flatMap(Collection::stream).map(it -> "%s-%s".formatted(it, FlowType.PUSH)).collect(Collectors.toSet());
    }
}

