/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.flow;

import java.util.Optional;
import java.util.Set;
import org.eclipse.edc.connector.dataplane.selector.spi.DataPlaneSelectorService;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.connector.transfer.dataplane.proxy.ConsumerPullDataPlaneProxyResolver;
import org.eclipse.edc.connector.transfer.spi.flow.DataFlowController;
import org.eclipse.edc.connector.transfer.spi.flow.FlowType;
import org.eclipse.edc.connector.transfer.spi.types.DataFlowResponse;
import org.eclipse.edc.connector.transfer.spi.types.DataRequest;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcess;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.asset.Asset;
import org.jetbrains.annotations.NotNull;

public class ConsumerPullTransferDataFlowController
implements DataFlowController {
    private final DataPlaneSelectorService selectorService;
    private final ConsumerPullDataPlaneProxyResolver resolver;
    private final Set<String> transferTypes = Set.of("%s-%s".formatted("HttpData", FlowType.PULL));

    public ConsumerPullTransferDataFlowController(DataPlaneSelectorService selectorService, ConsumerPullDataPlaneProxyResolver resolver) {
        this.selectorService = selectorService;
        this.resolver = resolver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canHandle(TransferProcess transferProcess) {
        if ("HttpProxy".equals(transferProcess.getDestinationType())) return true;
        if (Optional.ofNullable(transferProcess.getTransferType()).map(this.transferTypes::contains).orElse(false) == false) return false;
        return true;
    }

    @NotNull
    public StatusResult<DataFlowResponse> initiateFlow(TransferProcess transferProcess, Policy policy) {
        DataAddress contentAddress = transferProcess.getContentDataAddress();
        DataRequest dataRequest = transferProcess.getDataRequest();
        return Optional.ofNullable(this.selectorService.select(contentAddress, this.destinationAddress(dataRequest))).map(instance -> (StatusResult)this.resolver.toDataAddress(dataRequest, contentAddress, (DataPlaneInstance)instance).map(this::toResponse).map(StatusResult::success).orElse(failure -> StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)("Failed to generate proxy: " + failure.getFailureDetail())))).orElse(StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)String.format("Failed to find DataPlaneInstance for source/destination: %s/%s", contentAddress.getType(), "HttpProxy")));
    }

    private DataAddress destinationAddress(DataRequest dataRequest) {
        if (this.transferTypes.contains(dataRequest.getDestinationType())) {
            DataAddress.Builder dadBuilder = DataAddress.Builder.newInstance();
            dataRequest.getDataDestination().getProperties().forEach((arg_0, arg_1) -> ((DataAddress.Builder)dadBuilder).property(arg_0, arg_1));
            return dadBuilder.type("HttpProxy").build();
        }
        return dataRequest.getDataDestination();
    }

    public StatusResult<Void> terminate(TransferProcess transferProcess) {
        return StatusResult.success();
    }

    public Set<String> transferTypesFor(Asset asset) {
        return this.transferTypes;
    }

    private DataFlowResponse toResponse(DataAddress address) {
        return DataFlowResponse.Builder.newInstance().dataAddress(address).build();
    }
}

