/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.transfer.dataplane.api;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.eclipse.edc.connector.transfer.dataplane.api.ConsumerPullTransferTokenValidationApi;
import org.eclipse.edc.connector.transfer.dataplane.spi.security.DataEncrypter;
import org.eclipse.edc.keys.spi.PublicKeyResolver;
import org.eclipse.edc.spi.iam.ClaimToken;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.token.spi.TokenValidationRule;
import org.eclipse.edc.token.spi.TokenValidationService;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.NotAuthorizedException;

@Path(value="/token")
public class ConsumerPullTransferTokenValidationApiController
implements ConsumerPullTransferTokenValidationApi {
    private final TokenValidationService service;
    private final DataEncrypter dataEncrypter;
    private final TypeManager typeManager;
    private final PublicKeyResolver publicKeyResolver;

    public ConsumerPullTransferTokenValidationApiController(TokenValidationService service, DataEncrypter dataEncrypter, TypeManager typeManager, PublicKeyResolver publicKeyResolver) {
        this.service = service;
        this.dataEncrypter = dataEncrypter;
        this.typeManager = typeManager;
        this.publicKeyResolver = publicKeyResolver;
    }

    @Override
    @GET
    @Produces(value={"application/json"})
    public DataAddress validate(@HeaderParam(value="Authorization") String token) {
        return (DataAddress)this.service.validate(token, this.publicKeyResolver, new TokenValidationRule[0]).map(this::extractDataAddressClaim).map(this::toDataAddress).orElseThrow(failure -> new NotAuthorizedException("Token validation failed: " + failure.getFailureDetail()));
    }

    String extractDataAddressClaim(ClaimToken claims) {
        Object claim = claims.getClaim("dad");
        if (!(claim instanceof String)) {
            throw new InvalidRequestException(String.format("Missing claim `%s` in token", "dad"));
        }
        return (String)claim;
    }

    private DataAddress toDataAddress(String claim) {
        return (DataAddress)this.typeManager.readValue(this.dataEncrypter.decrypt(claim), DataAddress.class);
    }
}

