/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.transfer.dataplane.flow;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.edc.connector.controlplane.asset.spi.domain.Asset;
import org.eclipse.edc.connector.controlplane.transfer.spi.callback.ControlApiUrl;
import org.eclipse.edc.connector.controlplane.transfer.spi.flow.DataFlowController;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.DataFlowResponse;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.TransferProcess;
import org.eclipse.edc.connector.dataplane.selector.spi.DataPlaneSelectorService;
import org.eclipse.edc.connector.dataplane.selector.spi.client.DataPlaneClientFactory;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;
import org.eclipse.edc.spi.types.domain.transfer.FlowType;
import org.jetbrains.annotations.NotNull;

@Deprecated(since="0.5.1")
public class ProviderPushTransferDataFlowController
implements DataFlowController {
    private final ControlApiUrl callbackUrl;
    private final DataPlaneSelectorService selectorClient;
    private final DataPlaneClientFactory clientFactory;
    private final Set<String> transferTypes = Set.of("%s-%s".formatted("HttpData", FlowType.PULL));

    public ProviderPushTransferDataFlowController(ControlApiUrl callbackUrl, DataPlaneSelectorService selectorClient, DataPlaneClientFactory clientFactory) {
        this.callbackUrl = callbackUrl;
        this.selectorClient = selectorClient;
        this.clientFactory = clientFactory;
    }

    public boolean canHandle(TransferProcess transferProcess) {
        return !"HttpProxy".equals(transferProcess.getDestinationType()) && Optional.ofNullable(transferProcess.getTransferType()).map(type -> !this.transferTypes.contains(type)).orElse(true) != false;
    }

    @NotNull
    public StatusResult<DataFlowResponse> start(TransferProcess transferProcess, Policy policy) {
        DataFlowStartMessage dataFlowRequest = DataFlowStartMessage.Builder.newInstance().id(UUID.randomUUID().toString()).processId(transferProcess.getId()).sourceDataAddress(transferProcess.getContentDataAddress()).destinationDataAddress(transferProcess.getDataDestination()).flowType(FlowType.PUSH).callbackAddress(this.callbackUrl != null ? this.callbackUrl.get() : null).build();
        DataPlaneInstance dataPlaneInstance = this.selectorClient.select(transferProcess.getContentDataAddress(), transferProcess.getDataDestination());
        String dataPlaneInstanceId = dataPlaneInstance != null ? dataPlaneInstance.getId() : null;
        return (StatusResult)this.clientFactory.createClient(dataPlaneInstance).start(dataFlowRequest).map(it -> DataFlowResponse.Builder.newInstance().dataPlaneId(dataPlaneInstanceId).build());
    }

    public StatusResult<Void> suspend(TransferProcess transferProcess) {
        throw new RuntimeException("not implemented");
    }

    public StatusResult<Void> terminate(TransferProcess transferProcess) {
        return this.selectorClient.getAll().stream().filter(this.dataPlaneInstanceFilter(transferProcess)).map(arg_0 -> ((DataPlaneClientFactory)this.clientFactory).createClient(arg_0)).map(client -> client.terminate(transferProcess.getId())).reduce(StatusResult::merge).orElse(StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)"Failed to select the data plane for terminating the transfer process %s".formatted(transferProcess.getId())));
    }

    public Set<String> transferTypesFor(Asset asset) {
        return this.selectorClient.getAll().stream().filter(it -> it.getAllowedSourceTypes().contains(asset.getDataAddress().getType())).map(DataPlaneInstance::getAllowedDestTypes).flatMap(Collection::stream).map(it -> "%s-%s".formatted(it, FlowType.PUSH)).collect(Collectors.toSet());
    }

    private Predicate<DataPlaneInstance> dataPlaneInstanceFilter(TransferProcess transferProcess) {
        if (transferProcess.getDataPlaneId() != null) {
            return dataPlaneInstance -> dataPlaneInstance.getId().equals(transferProcess.getDataPlaneId());
        }
        return d -> true;
    }
}

