/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.transfer.dataplane.flow;

import java.util.Optional;
import java.util.Set;
import org.eclipse.edc.connector.controlplane.asset.spi.domain.Asset;
import org.eclipse.edc.connector.controlplane.transfer.dataplane.proxy.ConsumerPullDataPlaneProxyResolver;
import org.eclipse.edc.connector.controlplane.transfer.spi.flow.DataFlowController;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.DataFlowResponse;
import org.eclipse.edc.connector.controlplane.transfer.spi.types.TransferProcess;
import org.eclipse.edc.connector.dataplane.selector.spi.DataPlaneSelectorService;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.transfer.FlowType;
import org.jetbrains.annotations.NotNull;

@Deprecated(since="0.5.1")
public class ConsumerPullTransferDataFlowController
implements DataFlowController {
    private final DataPlaneSelectorService selectorService;
    private final ConsumerPullDataPlaneProxyResolver resolver;
    private final Set<String> transferTypes = Set.of("%s-%s".formatted("HttpData", FlowType.PULL));

    public ConsumerPullTransferDataFlowController(DataPlaneSelectorService selectorService, ConsumerPullDataPlaneProxyResolver resolver) {
        this.selectorService = selectorService;
        this.resolver = resolver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canHandle(TransferProcess transferProcess) {
        if ("HttpProxy".equals(transferProcess.getDestinationType())) return true;
        if (Optional.ofNullable(transferProcess.getTransferType()).map(this.transferTypes::contains).orElse(false) == false) return false;
        return true;
    }

    @NotNull
    public StatusResult<DataFlowResponse> start(TransferProcess transferProcess, Policy policy) {
        DataAddress contentAddress = transferProcess.getContentDataAddress();
        return Optional.ofNullable(this.selectorService.select(contentAddress, this.destinationAddress(transferProcess))).map(instance -> (StatusResult)this.resolver.toDataAddress(transferProcess, contentAddress, (DataPlaneInstance)instance).map(this::toResponse).map(StatusResult::success).orElse(failure -> StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)("Failed to generate proxy: " + failure.getFailureDetail())))).orElse(StatusResult.failure((ResponseStatus)ResponseStatus.FATAL_ERROR, (String)String.format("Failed to find DataPlaneInstance for source/destination: %s/%s", contentAddress.getType(), "HttpProxy")));
    }

    public StatusResult<Void> suspend(TransferProcess transferProcess) {
        throw new RuntimeException("not implemented");
    }

    public StatusResult<Void> terminate(TransferProcess transferProcess) {
        return StatusResult.success();
    }

    public Set<String> transferTypesFor(Asset asset) {
        return this.transferTypes;
    }

    private DataAddress destinationAddress(TransferProcess transferProcess) {
        if (this.transferTypes.contains(transferProcess.getDestinationType())) {
            DataAddress.Builder dadBuilder = DataAddress.Builder.newInstance();
            transferProcess.getDataDestination().getProperties().forEach((arg_0, arg_1) -> ((DataAddress.Builder)dadBuilder).property(arg_0, arg_1));
            return dadBuilder.type("HttpProxy").build();
        }
        return transferProcess.getDataDestination();
    }

    private DataFlowResponse toResponse(DataAddress address) {
        return DataFlowResponse.Builder.newInstance().dataAddress(address).build();
    }
}

