/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelPackage;
import org.eclipse.emf.texo.model.ModelResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicModelObject
implements ModelObject<DynamicModelObject>,
TexoComponent {
    private EClass eClass;
    private List<Object> values = new ArrayList<Object>();

    public void setData(DynamicModelObject source) {
        this.eClass = source.eClass;
        this.values.addAll(source.values);
    }

    @Override
    public ModelPackage getModelPackage() {
        return ModelResolver.getInstance().getModelPackage(this.eClass().getEPackage().getNsURI());
    }

    @Override
    public void setTarget(DynamicModelObject target) {
    }

    @Override
    public DynamicModelObject getTarget() {
        return this;
    }

    @Override
    public EClass eClass() {
        return this.eClass;
    }

    public void setEClass(EClass eClass) {
        this.eClass = eClass;
    }

    @Override
    public Object eGet(EStructuralFeature eStructuralFeature) {
        int featureId = this.eClass().getFeatureID(eStructuralFeature);
        if (featureId > this.values.size() - 1) {
            this.checkIncreaseValues(featureId);
        }
        Object value = this.values.get(featureId);
        if (eStructuralFeature.isMany() && value == null) {
            ArrayList newValue = new ArrayList();
            this.eSet(eStructuralFeature, newValue);
            return newValue;
        }
        return value;
    }

    @Override
    public void eSet(EStructuralFeature eStructuralFeature, Object value) {
        int featureId = this.eClass().getFeatureID(eStructuralFeature);
        if (featureId > this.values.size() - 1) {
            this.checkIncreaseValues(featureId);
        }
        this.values.set(featureId, value);
    }

    @Override
    public boolean eAddTo(EStructuralFeature eStructuralFeature, Object value) {
        Collection localValues;
        int featureId = this.eClass().getFeatureID(eStructuralFeature);
        if (featureId > this.values.size() - 1) {
            this.checkIncreaseValues(featureId);
        }
        if (!(localValues = (Collection)this.eGet(eStructuralFeature)).contains(value)) {
            return localValues.add(value);
        }
        return false;
    }

    @Override
    public boolean eRemoveFrom(EStructuralFeature eStructuralFeature, Object value) {
        Collection localValues;
        int featureId = this.eClass().getFeatureID(eStructuralFeature);
        if (featureId > this.values.size() - 1) {
            this.checkIncreaseValues(featureId);
        }
        if ((localValues = (Collection)this.eGet(eStructuralFeature)).contains(value)) {
            return localValues.remove(value);
        }
        return false;
    }

    private synchronized void checkIncreaseValues(int featureId) {
        int increaseBy = featureId - this.values.size() + 1;
        int i = 0;
        while (i < increaseBy) {
            this.values.add(null);
            ++i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.eClass.getName());
        sb.append("{");
        boolean added = false;
        for (EAttribute eAttribute : this.eClass.getEAllAttributes()) {
            int featureId = this.eClass().getFeatureID((EStructuralFeature)eAttribute);
            if (this.values.size() <= featureId || this.values.get(featureId) == null) continue;
            if (added) {
                sb.append(", ");
            }
            sb.append(String.valueOf(eAttribute.getName()) + ": " + this.values.get(featureId));
        }
        sb.append("}");
        return sb.toString();
    }
}

