/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.resolver;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.model.DynamicModelObject;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelPackage;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.provider.IdProvider;
import org.eclipse.emf.texo.resolver.ObjectResolver;
import org.eclipse.emf.texo.utils.ModelUtils;

public class DefaultObjectResolver
implements ObjectResolver,
TexoComponent {
    private static String serverUri = null;
    private Map<String, EObject> uriEObjectMap = new HashMap<String, EObject>();
    private URI uri = null;
    private boolean useWebServiceUriFormat = false;
    private int childLevels = -1;

    public static void setServerUri(String uri) {
        serverUri = uri;
    }

    public static String getServerUri() {
        return serverUri;
    }

    public void clearCache() {
        this.uriEObjectMap.clear();
    }

    public void addToCache(String uriString, EObject eObject) {
        this.uriEObjectMap.put(uriString, eObject);
    }

    public void addToCache(EObject eObject) {
        URI objectUri = this.toUri(eObject);
        if (objectUri != null) {
            this.uriEObjectMap.put(objectUri.toString(), eObject);
        }
    }

    public URI getUri() {
        if (this.uri == null) {
            this.uri = DefaultObjectResolver.getServerUri() != null ? URI.createURI((String)DefaultObjectResolver.getServerUri()) : URI.createURI((String)"http://www.eclipse.org/texo");
        }
        return this.appendParameters(this.uri);
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setUri(String uriString) {
        this.uri = URI.createURI((String)uriString);
    }

    public EObject resolveToEObject(Object object) {
        EObject eObject;
        URI toUri = this.toUri(object);
        if (toUri != null && (eObject = this.uriEObjectMap.get(toUri.toString())) != null) {
            return eObject;
        }
        ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(object);
        EClass eClass = modelObject.eClass();
        EObject eObject2 = EcoreUtil.create((EClass)eClass);
        if (toUri != null) {
            this.uriEObjectMap.put(toUri.toString(), eObject2);
        }
        return eObject2;
    }

    public Object resolveFromEObject(EObject eObject) {
        URI proxyUri = ((InternalEObject)eObject).eProxyURI();
        if (proxyUri != null) {
            boolean localRef;
            this.uriEObjectMap.put(proxyUri.toString(), eObject);
            String fragment = proxyUri.fragment();
            if (fragment != null && !(localRef = fragment.startsWith("/"))) {
                return this.fromUri(proxyUri);
            }
        }
        if (eObject.eClass() == EcorePackage.eINSTANCE.getEObject()) {
            DynamicModelObject modelObject = ComponentProvider.getInstance().newInstance(DynamicModelObject.class);
            modelObject.setEClass(eObject.eClass());
            return modelObject;
        }
        try {
            Object target;
            EAttribute eAttribute = IdProvider.getInstance().getIdEAttribute(eObject.eClass());
            if (eObject.eGet((EStructuralFeature)eAttribute) != null && (target = this.get(eObject.eClass(), eObject.eGet((EStructuralFeature)eAttribute))) != null) {
                return target;
            }
        }
        catch (IllegalStateException eAttribute) {
            // empty catch block
        }
        String nsUri = eObject.eClass().getEPackage().getNsURI();
        ModelPackage modelPackage = ModelResolver.getInstance().getModelPackage(nsUri);
        if (modelPackage == null) {
            throw new IllegalStateException("ModelPackage with ns uri: " + nsUri + " not found, did you initialize/touch the ModelPackage at application start?");
        }
        return modelPackage.getModelFactory().create(eObject.eClass());
    }

    public URI toUri(Object object) {
        String idString;
        EClass eClass;
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            URI proxyURI = ((InternalEObject)eObject).eProxyURI();
            if (proxyURI != null && ModelUtils.isTempURI(proxyURI.toString())) {
                return proxyURI;
            }
            eClass = eObject.eClass();
            if (!IdProvider.getInstance().hasIdEAttribute(eClass)) {
                return null;
            }
            idString = IdProvider.getInstance().getIdAsString(eObject);
            if (idString == null || idString.trim().length() == 0) {
                return null;
            }
        } else {
            ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(object);
            if (!IdProvider.getInstance().hasIdEAttribute(modelObject)) {
                return null;
            }
            idString = IdProvider.getInstance().getIdAsString(modelObject);
            if (idString == null || idString.trim().length() == 0) {
                return null;
            }
            eClass = modelObject.eClass();
        }
        if (this.isUseWebServiceUriFormat()) {
            return this.getUri().appendSegment(ModelUtils.getQualifiedNameFromEClass(eClass)).appendSegment(idString).appendFragment("");
        }
        return this.getUri().appendFragment(String.valueOf(ModelUtils.getQualifiedNameFromEClass(eClass)) + "||" + idString);
    }

    public URI toURI(EClass eClass, String idString) {
        if (this.isUseWebServiceUriFormat()) {
            return this.getUri().appendSegment(ModelUtils.getQualifiedNameFromEClass(eClass)).appendSegment(idString).appendFragment("");
        }
        return this.getUri().appendFragment(String.valueOf(ModelUtils.getQualifiedNameFromEClass(eClass)) + "||" + idString);
    }

    protected URI appendParameters(URI localUri) {
        if (this.getChildLevels() > 0) {
            return localUri.appendQuery("childLevels=" + this.getChildLevels());
        }
        return localUri;
    }

    public Object fromUri(URI objectUri) {
        if (ModelUtils.isTempURI(objectUri.toString())) {
            EObject eObject = this.getEObject(objectUri);
            if (eObject == null) {
                return null;
            }
            return this.get(eObject.eClass(), null);
        }
        ModelUtils.TypeIdTuple tuple = ModelUtils.getTypeAndIdFromUri(this.isUseWebServiceUriFormat(), objectUri);
        return this.get(tuple.getEClass(), tuple.getId());
    }

    public EObject getEObject(URI objectUri) {
        EObject eObject = this.uriEObjectMap.get(objectUri.toString());
        if (eObject == null) {
            return null;
        }
        return eObject;
    }

    public void removeFromCache(URI objectUri) {
        this.uriEObjectMap.remove(objectUri.toString());
    }

    public Object get(EClass eClass, Object id) {
        Object target = ModelResolver.getInstance().create(eClass);
        ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(target);
        modelObject.eSet((EStructuralFeature)IdProvider.getInstance().getIdEAttribute(eClass), id);
        return target;
    }

    public boolean isUseWebServiceUriFormat() {
        return this.useWebServiceUriFormat;
    }

    public void setUseWebServiceUriFormat(boolean useWebServiceUriFormat) {
        this.useWebServiceUriFormat = useWebServiceUriFormat;
    }

    public int getChildLevels() {
        return this.childLevels;
    }

    public void setChildLevels(int childLevels) {
        this.childLevels = childLevels;
    }
}

