/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.resolver;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.texo.resolver.DefaultObjectResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebServiceObjectResolver
extends DefaultObjectResolver {
    private final Map<String, Object> objectCache = new HashMap<String, Object>();

    public WebServiceObjectResolver() {
        this.setUseWebServiceUriFormat(true);
    }

    @Override
    public Object fromUri(URI objectUri) {
        String urlStr = objectUri.toString();
        if (this.objectCache.containsKey(urlStr)) {
            return this.objectCache.get(urlStr);
        }
        try {
            Object result = this.readObject(urlStr);
            if (result != null) {
                this.objectCache.put(urlStr, result);
                return result;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return super.fromUri(objectUri);
    }

    protected Object readObject(String urlStr) throws Exception {
        String line;
        HttpURLConnection hc = this.createConnection(urlStr);
        InputStream is = hc.getInputStream();
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        while ((line = reader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        return this.deserialize(urlStr, sb.toString());
    }

    protected abstract Object deserialize(String var1, String var2);

    protected HttpURLConnection createConnection(String urlStr) throws Exception {
        URL url = new URL(urlStr);
        HttpURLConnection hc = (HttpURLConnection)url.openConnection();
        hc.setRequestMethod("GET");
        hc.setAllowUserInteraction(false);
        hc.setDefaultUseCaches(false);
        hc.setDoOutput(true);
        hc.setDoInput(true);
        hc.setInstanceFollowRedirects(true);
        hc.setUseCaches(false);
        return hc;
    }

    public Map<String, Object> getObjectCache() {
        return this.objectCache;
    }
}

