/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.provider.IdProvider;
import org.eclipse.emf.texo.store.ObjectStore;
import org.eclipse.emf.texo.utils.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryObjectStore
extends ObjectStore {
    private static final String FROM = "from";
    private static final int FROM_LENGTH = "from".length();
    private final Map<EClass, List<Object>> data = new HashMap<EClass, List<Object>>();

    public void addData(Collection<Object> objects) {
        for (Object object : objects) {
            ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(object);
            EClass eClass = modelObject.eClass();
            List<Object> dataList = this.data.get(eClass);
            if (dataList == null) {
                dataList = new ArrayList<Object>();
                this.data.put(eClass, dataList);
            }
            dataList.add(object);
        }
    }

    @Override
    public Object get(EClass eClass, Object id) {
        List<Object> dataList = this.data.get(eClass);
        if (dataList != null) {
            for (Object o : dataList) {
                Object objectId = IdProvider.getInstance().getId(o);
                if (objectId == null || !objectId.equals(id)) continue;
                return o;
            }
        }
        return super.get(eClass, id);
    }

    @Override
    public long countNamedQuery(String name, Map<String, Object> namedParameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T get(Class<T> clz, Object id) {
        for (List<Object> dataList : this.data.values()) {
            for (Object o : dataList) {
                Object objectId = IdProvider.getInstance().getId(o);
                if (!clz.isAssignableFrom(o.getClass()) || objectId == null || !objectId.equals(id)) continue;
                return (T)o;
            }
        }
        return null;
    }

    @Override
    public <T> T update(T object) {
        return object;
    }

    @Override
    public <T> void remove(T object) {
        ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(object);
        List<Object> dataList = this.data.get(modelObject.eClass());
        if (dataList != null) {
            dataList.remove(object);
        }
    }

    @Override
    public <T> void refresh(T object) {
    }

    @Override
    public <T> void insert(T object) {
        ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(object);
        List<Object> dataList = this.data.get(modelObject.eClass());
        if (dataList != null && !dataList.contains(object)) {
            dataList.add(object);
        } else if (dataList == null) {
            dataList = new ArrayList<Object>();
            dataList.add(object);
        }
    }

    @Override
    public List<?> query(String qryStr, Map<String, Object> namedParameters, int firstResult, int maxResults) {
        int index = qryStr.indexOf(FROM);
        if (index != -1) {
            String eClassName = qryStr.substring(index + FROM_LENGTH);
            for (EClass eClass : this.data.keySet()) {
                if (!eClass.getName().equals(eClassName)) continue;
                return this.data.get(eClass);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<?> namedQuery(String name, Map<String, Object> namedParameters, int firstResult, int maxResults) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long count(String qryStr, Map<String, Object> namedParameters) {
        int index = qryStr.indexOf(FROM);
        if (index != -1) {
            String eClassName = qryStr.substring(index + FROM_LENGTH);
            for (EClass eClass : this.data.keySet()) {
                if (!eClass.getName().equals(eClassName)) continue;
                return this.data.size();
            }
        }
        return 0L;
    }

    @Override
    public List<?> query(EClass eClass, int firstResult, int maxResults) {
        List<Object> result = this.data.get(eClass);
        if (result == null) {
            return Collections.emptyList();
        }
        int from = 0;
        if (firstResult > -1) {
            from = firstResult;
        }
        int to = result.size();
        if (maxResults > -1) {
            to = from + maxResults;
        }
        if (from >= result.size() && (from = result.size()) == 0) {
            return Collections.emptyList();
        }
        if (to > result.size()) {
            to = result.size();
        }
        return result.subList(from, to);
    }

    @Override
    public Object getDelegate() {
        return this.data;
    }

    public List<Object> getReferingObjects(Object target, int maxResult, boolean includeContainmentReferences) {
        return null;
    }

    @Override
    public EObject getEObject(URI objectUri) {
        ModelUtils.TypeIdTuple tuple;
        EObject eObject = super.getEObject(objectUri);
        if (eObject == null && (eObject = (EObject)this.get((tuple = ModelUtils.getTypeAndIdFromUri(this.isUseWebServiceUriFormat(), objectUri)).getEClass(), tuple.getId())) == null) {
            eObject = EcoreUtil.create((EClass)tuple.getEClass());
            eObject.eSet((EStructuralFeature)IdProvider.getInstance().getIdEAttribute(tuple.getEClass()), tuple.getId());
        }
        return eObject;
    }
}

