/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.model.ModelConstants;
import org.eclipse.emf.texo.model.ModelEFactory;
import org.eclipse.emf.texo.model.ModelFeatureMapEntry;
import org.eclipse.emf.texo.model.ModelPackage;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.provider.IdProvider;
import org.eclipse.emf.texo.utils.Check;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    public static final String QUALIFIERSEPARATOR = "|";
    private static SimpleDateFormat xmlDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
    private static final String TEMP_URI_CODE = "tempUriNum";
    private static long TEMP_COUNTER = 0L;

    public static String getDocumentation(ENamedElement eNamedElement) {
        EAnnotation eAnnotation = eNamedElement.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
        if (eAnnotation == null) {
            return null;
        }
        if (eAnnotation.getDetails().get((Object)"documentation") != null) {
            return ((String)eAnnotation.getDetails().get((Object)"documentation")).trim();
        }
        return null;
    }

    public static void setEFactoryProxy(ModelPackage modelPackage, EPackage ePackage) {
        ModelEFactory modelEFactory = ComponentProvider.getInstance().newInstance(ModelEFactory.class);
        modelEFactory.setEPackage(ePackage);
        modelEFactory.setModelFactory(modelPackage.getModelFactory());
        Class<?> factoryClass = ePackage.getEFactoryInstance().getClass();
        ModelEFactory.EFactoryInvocationHandler handler = new ModelEFactory.EFactoryInvocationHandler(modelEFactory);
        Class[] interfaces = new Class[factoryClass.getInterfaces().length + 1];
        int i = 0;
        Class<?>[] classArray = factoryClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clz;
            interfaces[i] = clz = classArray[n2];
            ++i;
            ++n2;
        }
        interfaces[i] = InternalEObject.class;
        EFactory eFactory = (EFactory)Proxy.newProxyInstance(factoryClass.getClassLoader(), interfaces, (InvocationHandler)handler);
        ePackage.setEFactoryInstance(eFactory);
    }

    public static void setXMLDateFormat(SimpleDateFormat simpleDateFormat) {
        xmlDateFormat = simpleDateFormat;
    }

    public static SimpleDateFormat getXMLDateFormat() {
        return xmlDateFormat;
    }

    public static boolean isUnsettable(EStructuralFeature eFeature) {
        return !eFeature.isMany() && eFeature.isUnsettable() && eFeature.getDefaultValueLiteral() == null && eFeature.getLowerBound() == 0;
    }

    public static boolean isAnyType(EStructuralFeature eFeature) {
        EAnnotation eAnnotation = eFeature.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        if (eAnnotation == null) {
            return false;
        }
        String kind = (String)eAnnotation.getDetails().get((Object)"kind");
        return kind != null && (kind.equals("elementWildcard") || kind.equals("attributeWildcard"));
    }

    public static Object findValue(ModelFeatureMapEntry<?> modelFeatureMap) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)modelFeatureMap.getEStructuralFeature())) {
            ModelFeatureMapEntry<?> modelFeatureMapEntry = ModelResolver.getInstance().getModelFeatureMapEntry(modelFeatureMap.getEStructuralFeature(), modelFeatureMap.getValue());
            return ModelUtils.findValue(modelFeatureMapEntry);
        }
        return modelFeatureMap.getValue();
    }

    public static EStructuralFeature findFeature(ModelFeatureMapEntry<?> modelFeatureMap) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)modelFeatureMap.getEStructuralFeature())) {
            ModelFeatureMapEntry<?> modelFeatureMapEntry = ModelResolver.getInstance().getModelFeatureMapEntry(modelFeatureMap.getEStructuralFeature(), modelFeatureMap.getValue());
            return ModelUtils.findFeature(modelFeatureMapEntry);
        }
        return modelFeatureMap.getEStructuralFeature();
    }

    public static String getQualifiedNameFromEStructuralFeature(EStructuralFeature eFeature) {
        return String.valueOf(ModelUtils.getQualifiedNameFromEClass(eFeature.getEContainingClass())) + QUALIFIERSEPARATOR + eFeature.getName();
    }

    public static EStructuralFeature getEStructuralFeatureFromQualifiedName(String name) {
        int index = name.lastIndexOf(QUALIFIERSEPARATOR);
        String eClassString = name.substring(0, index);
        EClass eClass = ModelUtils.getEClassFromQualifiedName(eClassString);
        String featureName = name.substring(1 + index);
        return eClass.getEStructuralFeature(featureName);
    }

    public static String getQualifiedNameFromEClass(EClass eClass) {
        return String.valueOf(eClass.getEPackage().getNsPrefix()) + QUALIFIERSEPARATOR + eClass.getName();
    }

    public static EClass getEClassFromQualifiedName(String name) {
        return (EClass)ModelUtils.getEClassifierFromQualifiedName(name);
    }

    public static EClassifier getEClassifierFromQualifiedName(String name) {
        EPackage ePackage;
        String nameSpacePrefix = null;
        String eClassName = name;
        if (eClassName.contains(QUALIFIERSEPARATOR)) {
            int index = eClassName.indexOf(QUALIFIERSEPARATOR);
            nameSpacePrefix = eClassName.substring(0, index);
            eClassName = eClassName.substring(index + 1);
        }
        for (ModelPackage modelPackage : ModelResolver.getInstance().getModelPackages()) {
            ePackage = modelPackage.getEPackage();
            if (nameSpacePrefix != null && !ePackage.getNsPrefix().equals(nameSpacePrefix)) continue;
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!eClassifier.getName().equals(eClassName)) continue;
                return eClassifier;
            }
        }
        for (ModelPackage key : new HashSet(ModelResolver.getInstance().getEPackageRegistry().keySet())) {
            ePackage = ModelResolver.getInstance().getEPackageRegistry().getEPackage((String)((Object)key));
            if (nameSpacePrefix != null && !ePackage.getNsPrefix().equals(nameSpacePrefix)) continue;
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!eClassifier.getName().equals(eClassName)) continue;
                return eClassifier;
            }
        }
        if (nameSpacePrefix != null) {
            XMLTypePackage otherEPackage = null;
            if ("ecore.xml.type".equals(nameSpacePrefix)) {
                otherEPackage = XMLTypePackage.eINSTANCE;
            } else if ("ecore".equals(nameSpacePrefix)) {
                otherEPackage = EcorePackage.eINSTANCE;
            }
            if (otherEPackage != null) {
                for (EClassifier eClassifier : otherEPackage.getEClassifiers()) {
                    if (!eClassifier.getName().equals(eClassName)) continue;
                    return eClassifier;
                }
            }
        }
        throw new IllegalArgumentException("No EClass(ifier) found using name " + name);
    }

    public static EPackage getEPackageFromNameUriOrPrefix(String identifier) {
        ArrayList<Object> toSearch = new ArrayList<Object>();
        toSearch.add(XMLTypePackage.eINSTANCE);
        toSearch.add(EcorePackage.eINSTANCE);
        for (ModelPackage modelPackage : ModelResolver.getInstance().getModelPackages()) {
            EPackage ePackage = modelPackage.getEPackage();
            toSearch.add(ePackage);
        }
        for (EPackage ePackage : toSearch) {
            if (!identifier.equals(ePackage.getNsURI())) continue;
            return ePackage;
        }
        for (EPackage ePackage : toSearch) {
            if (!identifier.equals(ePackage.getName())) continue;
            return ePackage;
        }
        for (EPackage ePackage : toSearch) {
            if (!identifier.equals(ePackage.getNsPrefix())) continue;
            return ePackage;
        }
        throw new IllegalArgumentException("No EPackage found using identifier " + identifier);
    }

    public static String toLowerCase(String value) {
        return value == null ? null : value.toLowerCase(Locale.ENGLISH);
    }

    public static String toUpperCase(String value) {
        return value == null ? null : value.toUpperCase(Locale.ENGLISH);
    }

    public static String lowerCaseFirst(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 1) {
            return ModelUtils.toLowerCase(value);
        }
        return String.valueOf(value.substring(0, 1).toLowerCase(Locale.ENGLISH)) + value.substring(1);
    }

    public static String upCaseFirst(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 1) {
            return ModelUtils.toUpperCase(value);
        }
        return String.valueOf(value.substring(0, 1).toUpperCase(Locale.ENGLISH)) + value.substring(1);
    }

    public static synchronized Date createFromXML(String xmlString) {
        try {
            return xmlDateFormat.parse(xmlString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static synchronized String convertToXML(Date dt) {
        return xmlDateFormat.format(dt);
    }

    public static void readEPackagesFromFile(ModelPackage modelPackage) {
        if (ModelResolver.getInstance().getEPackageRegistry().getEPackage(modelPackage.getNsURI()) != null) {
            return;
        }
        String ecoreFileName = modelPackage.getEcoreFileName();
        Check.isNotEmpty(ecoreFileName, "Ecore file of ModelPackage may not be empty.");
        if (ecoreFileName != null && ecoreFileName.length() > 0) {
            try {
                Resource res = new EcoreResourceFactoryImpl().createResource(URI.createURI((String)modelPackage.getNsURI()));
                InputStream is = modelPackage.getClass().getResourceAsStream(ecoreFileName);
                if (is == null) {
                    throw new RuntimeException("File " + ecoreFileName + " not found within class path of " + modelPackage.getClass().getName());
                }
                res.load(is, Collections.EMPTY_MAP);
                is.close();
                TreeIterator it = res.getAllContents();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof EPackage)) continue;
                    EPackage epack = (EPackage)obj;
                    ModelUtils.registerEPackage(epack, ModelResolver.getInstance().getEPackageRegistry());
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Exception while loading models from ecorefile " + ecoreFileName);
            }
        }
    }

    public static EPackage registerEPackage(EPackage ePackage, EPackage.Registry registry) {
        Object packageObject;
        if (registry.containsKey((Object)ePackage.getNsURI()) && (packageObject = registry.get((Object)ePackage.getNsURI())) instanceof EPackage) {
            return (EPackage)packageObject;
        }
        registry.put((Object)ePackage.getNsURI(), (Object)ePackage);
        for (EPackage eSubPackage : new ArrayList(ePackage.getESubpackages())) {
            EPackage registeredSubPackage = ModelUtils.registerEPackage(eSubPackage, registry);
            if (registeredSubPackage == eSubPackage) continue;
            int currentIndex = ePackage.getESubpackages().indexOf((Object)eSubPackage);
            assert (eSubPackage == ePackage.getESubpackages().set(currentIndex, (Object)registeredSubPackage));
        }
        return ePackage;
    }

    public static EEnum getEnumBaseDataTypeIfObject(EDataType eDataType) {
        if (eDataType instanceof EEnum) {
            return null;
        }
        ExtendedMetaData extendedMetaData = ExtendedMetaData.INSTANCE;
        EDataType baseDataType = eDataType;
        while (baseDataType != null) {
            if (baseDataType instanceof EEnum) {
                return (EEnum)baseDataType;
            }
            baseDataType = extendedMetaData.getBaseType(baseDataType);
        }
        return null;
    }

    public static EPackage getEPackage(String nsuri) {
        EPackage epackage = ModelResolver.getInstance().getEPackageRegistry().getEPackage(nsuri);
        if (epackage == null) {
            throw new IllegalArgumentException("No EPackage registered using the nsuri: " + nsuri);
        }
        return epackage;
    }

    public static boolean isEEnum(EDataType eDataType) {
        if (eDataType == EcorePackage.eINSTANCE.getEEnumerator()) {
            return false;
        }
        return eDataType instanceof EEnum || Enumerator.class.getName().equals(eDataType.getInstanceClassName());
    }

    public static boolean isEMap(EClass eClass) {
        return eClass != null && eClass.getInstanceClass() != null && Map.Entry.class.isAssignableFrom(eClass.getInstanceClass()) && eClass.getEStructuralFeature("key") != null && eClass.getEStructuralFeature("value") != null;
    }

    public static boolean isEMap(EStructuralFeature eFeature) {
        if (!(eFeature.getEType() instanceof EClass)) {
            return false;
        }
        return ModelUtils.isEMap((EClass)eFeature.getEType());
    }

    public static boolean isMixed(EStructuralFeature feature) {
        EAnnotation eAnnotation = feature.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        if (eAnnotation == null) {
            return false;
        }
        String kind = (String)eAnnotation.getDetails().get((Object)"kind");
        String name = (String)eAnnotation.getDetails().get((Object)"name");
        return kind != null && kind.compareTo("elementWildcard") == 0 && name != null && name.compareTo(":mixed") == 0;
    }

    public static boolean hasMixedEFeature(EClass eClass) {
        for (EStructuralFeature eFeature : eClass.getEAllStructuralFeatures()) {
            if (!ModelUtils.isMixed(eFeature)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEAnnotation(EModelElement eModelElement, String annotationKey) {
        return ModelUtils.getEAnnotation(eModelElement, annotationKey) != null;
    }

    public static String getEAnnotation(EModelElement eModelElement, String annotationKey) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation("org.eclipse.emf.texo");
        if (eAnnotation == null) {
            return null;
        }
        return (String)eAnnotation.getDetails().get((Object)annotationKey);
    }

    public static synchronized URI makeTempURI(URI baseURI) {
        long tempCounter = ++TEMP_COUNTER;
        return baseURI.appendQuery("tempUriNum=" + tempCounter);
    }

    public static boolean isTempURI(String baseURI) {
        return baseURI.contains("tempUriNum=");
    }

    public static URI convertToEMFURI(URI webServiceURI) {
        TypeIdTuple tuple = ModelUtils.getTypeAndIdFromUri(true, webServiceURI);
        URI baseURI = webServiceURI.trimSegments(2);
        return baseURI.appendFragment(String.valueOf(ModelUtils.getQualifiedNameFromEClass(tuple.getEClass())) + "||" + tuple.getId());
    }

    public static URI convertToWebServiceURI(URI emfURI) {
        TypeIdTuple tuple = ModelUtils.getTypeAndIdFromUri(true, emfURI);
        URI baseURI = emfURI.trimFragment();
        return baseURI.appendSegment(ModelUtils.getQualifiedNameFromEClass(tuple.getEClass())).appendSegment("" + tuple.getId()).appendFragment("");
    }

    public static TypeIdTuple getTypeAndIdFromUri(boolean useWebServiceFormat, URI objectUri) {
        Object idValue;
        EClass eClass;
        if (useWebServiceFormat && !objectUri.toString().contains("||")) {
            String idString = objectUri.lastSegment();
            String eClassName = objectUri.trimSegments(1).lastSegment();
            eClass = ModelUtils.getEClassFromQualifiedName(eClassName);
            if (eClass == null) {
                throw new IllegalArgumentException("No eclass found for uri " + objectUri.toString());
            }
            idValue = IdProvider.getInstance().convertIdStringToId(eClass, idString);
        } else {
            int separatorIndex;
            String fragment = objectUri.fragment();
            int n = separatorIndex = fragment == null ? -1 : fragment.indexOf("||");
            if (fragment == null || separatorIndex == -1) {
                if (fragment == null || fragment.trim().length() == 0) {
                    throw new IllegalArgumentException("No fragment, is the object URL maybe in webservice format? Consider setting the property useWebServiceFormat to true on the ObjectResolver (of the converter)");
                }
                throw new IllegalArgumentException("Fragment format not supported for fragment: " + fragment);
            }
            eClass = ModelUtils.getEClassFromQualifiedName(fragment.substring(0, separatorIndex));
            String idString = fragment.substring(separatorIndex + ModelConstants.FRAGMENTSEPARATOR_LENGTH);
            idValue = IdProvider.getInstance().convertIdStringToId(eClass, idString);
        }
        TypeIdTuple tuple = new TypeIdTuple();
        tuple.setEClass(eClass);
        tuple.setId(idValue);
        return tuple;
    }

    public static class TypeIdTuple {
        private EClass eClass;
        private Object id;

        public EClass getEClass() {
            return this.eClass;
        }

        public void setEClass(EClass eClass) {
            this.eClass = eClass;
        }

        public Object getId() {
            return this.id;
        }

        public void setId(Object id) {
            this.id = id;
        }
    }
}

