/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.converter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.model.ModelFeatureMapEntry;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.provider.IdProvider;
import org.eclipse.emf.texo.utils.ModelUtils;

public class ObjectComparator
implements TexoComponent {
    private Stack<String> path = new Stack();
    private List<Object> compared = new ArrayList<Object>();

    public void clear() {
        this.path.clear();
        this.compared.clear();
    }

    public void compare(Object o1, Object o2) {
        if (o1 == o2) {
            return;
        }
        if (this.compared.contains(o1)) {
            return;
        }
        this.compared.add(o1);
        if (o1 == null || o2 == null) {
            throw new ObjectComparatorException(o1, o2, "One of the values is null: " + o1 + "/" + o2 + this.getPath());
        }
        if (ModelResolver.getInstance().isModelEnabled(o1) != ModelResolver.getInstance().isModelEnabled(o2)) {
            throw new ObjectComparatorException(o1, o2, "One of these 2 is not model enabled: " + o1 + "/" + o2 + this.getPath());
        }
        ModelObject<?> m1 = ModelResolver.getInstance().getModelObject(o1);
        ModelObject<?> m2 = ModelResolver.getInstance().getModelObject(o2);
        this.compareType(m1, m2);
        this.path.push(m1.eClass().getName());
        for (EStructuralFeature eFeature : m1.eClass().getEAllStructuralFeatures()) {
            if (eFeature.isVolatile()) continue;
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eFeature)) {
                this.compareFeatureMapEFeature(m1, m2, eFeature);
                continue;
            }
            if (ModelUtils.isEMap(eFeature)) {
                this.compareMapEFeature(m1, m2, eFeature);
                continue;
            }
            if (eFeature.isMany()) {
                this.compareManyEFeature(m1, m2, eFeature);
                continue;
            }
            if (eFeature instanceof EAttribute) {
                this.compareSingleEAttribute(m1, m2, (EAttribute)eFeature);
                continue;
            }
            this.compareSingleEReference(m1, m2, (EReference)eFeature);
        }
        this.path.pop();
    }

    protected void compareFeatureMapEFeature(ModelObject<?> m1, ModelObject<?> m2, EStructuralFeature eFeature) {
        Collection targetCollection = (Collection)m2.eGet(eFeature);
        Collection sourceCollection = (Collection)m1.eGet(eFeature);
        this.path.push(eFeature.getName());
        if (targetCollection.size() != sourceCollection.size()) {
            throw new ObjectComparatorException(m1, m2, "Collections have different sizes " + sourceCollection.size() + "/" + targetCollection.size() + this.getPath());
        }
        Iterator targetIterator = targetCollection.iterator();
        int i = 0;
        for (Object sourceEntry : (Collection)m1.eGet(eFeature)) {
            this.path.push("[" + i + "]");
            Object targetEntry = targetIterator.next();
            ModelFeatureMapEntry<?> sourceModelEntry = ModelResolver.getInstance().getModelFeatureMapEntry(eFeature, sourceEntry);
            ModelFeatureMapEntry<?> targetModelEntry = ModelResolver.getInstance().getModelFeatureMapEntry(eFeature, targetEntry);
            if (sourceModelEntry.getEStructuralFeature() != targetModelEntry.getEStructuralFeature()) {
                throw new ObjectComparatorException(sourceModelEntry, targetModelEntry, "Feature map entries have different efeatures " + sourceModelEntry + "/" + targetModelEntry + this.getPath());
            }
            Object v1 = sourceModelEntry.getValue();
            Object v2 = targetModelEntry.getValue();
            if (sourceModelEntry.getEStructuralFeature() instanceof EReference) {
                this.compare(v1, v2);
            } else {
                this.compareValue(v1, v2, (EAttribute)sourceModelEntry.getEStructuralFeature());
            }
            this.path.pop();
            ++i;
        }
        this.path.pop();
    }

    protected void compareManyEFeature(ModelObject<?> m1, ModelObject<?> m2, EStructuralFeature eFeature) {
        Object v1 = m1.eGet(eFeature);
        Object v2 = m2.eGet(eFeature);
        if (v1.getClass() != v2.getClass()) {
            throw new ObjectComparatorException(v1, v2, "Different many efeature value types " + v1 + "/" + v2 + this.getPath());
        }
        boolean compareAsSet = v1 instanceof Set;
        if (!compareAsSet && eFeature instanceof EReference) {
            EReference eReference = (EReference)eFeature;
            boolean bl = compareAsSet = eReference.isMany() && eReference.getEOpposite() != null && eReference.getEOpposite().isMany();
        }
        if (ModelUtils.isEMap(eFeature)) {
            this.compareMapEFeature(m1, m2, eFeature);
        } else if (compareAsSet) {
            this.compareSetEFeature(m1, m2, eFeature);
        } else if (v2 instanceof List) {
            this.compareListEFeature(m1, m2, eFeature);
        }
    }

    protected void compareMapEFeature(ModelObject<?> m1, ModelObject<?> m2, EStructuralFeature eFeature) {
        this.path.push(eFeature.getName());
        Map c1 = (Map)m1.eGet(eFeature);
        Map c2 = (Map)m2.eGet(eFeature);
        if (c1.size() != c2.size()) {
            throw new ObjectComparatorException(m1, m2, "Different collection sizes " + c1.size() + "/" + c2.size() + this.getPath());
        }
        EClass mapEClass = ((EReference)eFeature).getEReferenceType();
        EStructuralFeature keyFeature = mapEClass.getEStructuralFeature("key");
        for (Object key : c1.keySet()) {
            Object id1;
            Object o1 = c1.get(key);
            Object o2 = null;
            if (keyFeature instanceof EReference && IdProvider.getInstance().hasIdEAttribute(key) && (id1 = IdProvider.getInstance().getId(key)) != null) {
                for (Object key2 : c2.keySet()) {
                    Object id2;
                    if (!IdProvider.getInstance().hasIdEAttribute(key2) || (id2 = IdProvider.getInstance().getId(key2)) == null || !id1.equals(id2)) continue;
                    o2 = c2.get(key2);
                    break;
                }
            }
            if (o2 == null) {
                o2 = c2.get(key);
            }
            this.path.push("[" + key + "]");
            if (eFeature instanceof EReference) {
                this.compare(o1, o2);
            } else {
                this.compareValue(o1, o2, (EAttribute)eFeature);
            }
            this.path.pop();
        }
        this.path.pop();
    }

    protected void compareSetEFeature(ModelObject<?> m1, ModelObject<?> m2, EStructuralFeature eFeature) {
        this.path.push(eFeature.getName());
        Collection c1 = (Collection)m1.eGet(eFeature);
        Collection c2 = (Collection)m2.eGet(eFeature);
        if (c1.size() != c2.size()) {
            throw new ObjectComparatorException(m1, m2, "Different collection sizes " + c1.size() + "/" + c2.size() + this.getPath());
        }
        Iterator i1 = c1.iterator();
        int cnt = 0;
        while (i1.hasNext()) {
            Object o1 = i1.next();
            this.path.push("[" + cnt + "]");
            boolean found = false;
            for (Object o2 : c2) {
                try {
                    if (eFeature instanceof EReference) {
                        this.compare(o1, o2);
                    } else {
                        this.compareValue(o1, o2, (EAttribute)eFeature);
                    }
                    found = true;
                    break;
                }
                catch (ObjectComparatorException objectComparatorException) {
                    // empty catch block
                }
            }
            if (!found) {
                throw new ObjectComparatorException(m1, m2, "Value " + o1 + " not present in collection " + this.getPath());
            }
            this.path.pop();
            ++cnt;
        }
        this.path.pop();
    }

    protected void compareListEFeature(ModelObject<?> m1, ModelObject<?> m2, EStructuralFeature eFeature) {
        this.path.push(eFeature.getName());
        Collection c1 = (Collection)m1.eGet(eFeature);
        Collection c2 = (Collection)m2.eGet(eFeature);
        if (c1.size() != c2.size()) {
            throw new ObjectComparatorException(m1, m2, "Different collection sizes " + c1.size() + "/" + c2.size() + this.getPath());
        }
        Iterator i1 = c1.iterator();
        Iterator i2 = c2.iterator();
        int cnt = 0;
        while (i1.hasNext()) {
            Object o1 = i1.next();
            Object o2 = i2.next();
            this.path.push("[" + cnt + "]");
            if (eFeature instanceof EReference) {
                this.compare(o1, o2);
            } else {
                this.compareValue(o1, o2, (EAttribute)eFeature);
            }
            this.path.pop();
            ++cnt;
        }
        this.path.pop();
    }

    protected void compareSingleEAttribute(ModelObject<?> m1, ModelObject<?> m2, EAttribute eAttribute) {
        this.path.push(eAttribute.getName());
        this.compareValue(m1.eGet((EStructuralFeature)eAttribute), m2.eGet((EStructuralFeature)eAttribute), eAttribute);
        this.path.pop();
    }

    protected void compareSingleEReference(ModelObject<?> m1, ModelObject<?> m2, EReference eReference) {
        this.path.push(eReference.getName());
        try {
            Object o1 = m1.eGet((EStructuralFeature)eReference);
            Object o2 = m2.eGet((EStructuralFeature)eReference);
            if (o1 == o2) {
                return;
            }
            if (o1 != null && o2 == null) {
                throw new ObjectComparatorException(o1, o2, "Different Values " + o1 + "/" + o2 + this.getPath());
            }
            if (o1 == null && o2 != null) {
                throw new ObjectComparatorException(o1, o2, "Different Values " + o1 + "/" + o2 + this.getPath());
            }
            this.compare(o1, o2);
        }
        finally {
            this.path.pop();
        }
    }

    protected void compareValue(Object v1, Object v2, EAttribute eAttribute) {
        if (v1 == v2) {
            return;
        }
        System.err.println(v1);
        if (v1 != null && v1.getClass().isArray()) {
            this.checkEqualArrays(v1, v2, eAttribute);
        } else if (v1 != null && !v1.equals(v2)) {
            throw new ObjectComparatorException(v1, v2, "Different values " + v1 + "/" + v2 + this.getPath());
        }
    }

    private void checkEqualArrays(Object v1, Object v2, EAttribute eAttribute) {
        int l2;
        if (v1 == null || !v1.getClass().isArray() || v2 == null || !v2.getClass().isArray()) {
            throw new ObjectComparatorException(v1, v2, "Different values " + v1 + "/" + v2 + this.getPath());
        }
        int l1 = Array.getLength(v1);
        if (l1 != (l2 = Array.getLength(v1))) {
            throw new ObjectComparatorException(v1, v2, "Different values " + v1 + "/" + v2 + this.getPath());
        }
        int i = 0;
        while (i < l1) {
            Object e1 = Array.get(v1, i);
            Object e2 = Array.get(v2, i);
            this.compareValue(e1, e2, eAttribute);
            ++i;
        }
    }

    protected void compareType(ModelObject<?> m1, ModelObject<?> m2) {
        if (m1.eClass() != m2.eClass()) {
            throw new ObjectComparatorException(m1, m2, "Different EClasses " + m1.eClass().getName() + "/" + m2.eClass().getName() + this.getPath());
        }
    }

    protected String getPath() {
        StringBuilder sb = new StringBuilder(" - path: ");
        for (String part : this.path) {
            sb.append("/" + part);
        }
        return sb.toString();
    }

    public class ObjectComparatorException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private Object o1;
        private Object o2;

        public ObjectComparatorException(Object o1, Object o2, String msg) {
            super(msg);
            this.o1 = o1;
            this.o2 = o2;
        }

        protected Object getO1() {
            return this.o1;
        }

        protected Object getO2() {
            return this.o2;
        }
    }
}

