/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.provider;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.component.TexoStaticSingleton;
import org.eclipse.emf.texo.model.ModelFactory;
import org.eclipse.emf.texo.model.ModelObject;
import org.eclipse.emf.texo.model.ModelPackage;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.utils.ModelUtils;

public class IdProvider
implements TexoComponent,
TexoStaticSingleton {
    private static final String EMPTY_ID_STRING = "";
    private static IdProvider instance = ComponentProvider.getInstance().newInstance(IdProvider.class);
    private final Map<EClass, EAttribute> idEAttributes = new ConcurrentHashMap<EClass, EAttribute>();
    private final Set<EClass> noIdEAttributes = new HashSet<EClass>();

    public static IdProvider getInstance() {
        return instance;
    }

    public static void setInstance(IdProvider instance) {
        IdProvider.instance = instance;
    }

    public Object getId(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EAttribute idEAttribute = this.getCreateIdEAttribute(eObject.eClass());
            return eObject.eGet((EStructuralFeature)idEAttribute);
        }
        ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(object);
        return modelObject.eGet((EStructuralFeature)this.getCreateIdEAttribute(modelObject.eClass()));
    }

    public String getIdAsString(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EAttribute idEAttribute = this.getCreateIdEAttribute(eObject.eClass());
            return this.getIdAsString(eObject.eClass(), eObject.eGet((EStructuralFeature)idEAttribute));
        }
        return this.getIdAsString(ModelResolver.getInstance().getModelObject(object));
    }

    public String getIdAsString(ModelObject<?> modelObject) {
        EAttribute idEAttribute = this.getCreateIdEAttribute(modelObject.eClass());
        return this.getIdAsString(modelObject.eClass(), modelObject.eGet((EStructuralFeature)idEAttribute));
    }

    public String getIdAsString(EClass eClass, Object idValue) {
        EAttribute idEAttribute = this.getCreateIdEAttribute(eClass);
        EDataType eDataType = idEAttribute.getEAttributeType();
        if (idValue == null) {
            return EMPTY_ID_STRING;
        }
        String eDataTypePackageUri = eDataType.getEPackage().getNsURI();
        ModelPackage modelPackage = ModelResolver.getInstance().getModelPackage(eDataTypePackageUri);
        if (modelPackage != null) {
            ModelFactory modelFactory = modelPackage.getModelFactory();
            return modelFactory.convertToString(eDataType, idValue);
        }
        return eDataType.getEPackage().getEFactoryInstance().convertToString(eDataType, idValue);
    }

    public Object convertIdStringToId(EClass eClass, String idString) {
        if (idString == null || idString.trim().length() == 0) {
            return null;
        }
        EAttribute idEAttribute = this.getCreateIdEAttribute(eClass);
        EDataType eDataType = idEAttribute.getEAttributeType();
        String eDataTypePackageUri = eDataType.getEPackage().getNsURI();
        ModelPackage modelPackage = ModelResolver.getInstance().getModelPackage(eDataTypePackageUri);
        if (modelPackage != null) {
            ModelFactory modelFactory = modelPackage.getModelFactory();
            return modelFactory.createFromString(eDataType, idString);
        }
        return eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, idString);
    }

    public EAttribute getIdEAttribute(EClass eClass) {
        return this.getCreateIdEAttribute(eClass);
    }

    public boolean hasIdEAttribute(Object object) {
        ModelObject<?> modelObject = ModelResolver.getInstance().getModelObject(object);
        return this.hasIdEAttribute(modelObject.eClass());
    }

    public boolean hasIdEAttribute(EClass eClass) {
        EAttribute idEAttribute = this.idEAttributes.get(eClass);
        if (idEAttribute != null) {
            return true;
        }
        if (this.noIdEAttributes.contains(eClass)) {
            return false;
        }
        try {
            this.getCreateIdEAttribute(eClass);
            return true;
        }
        catch (IllegalStateException e) {
            this.noIdEAttributes.add(eClass);
            return false;
        }
    }

    protected EAttribute getCreateIdEAttribute(EClass eClass) {
        EAttribute idEAttribute = this.idEAttributes.get(eClass);
        if (idEAttribute != null) {
            return idEAttribute;
        }
        for (EStructuralFeature eFeature : eClass.getEAllStructuralFeatures()) {
            if (!ModelUtils.hasEAnnotation((EModelElement)eFeature, "id")) continue;
            if (eFeature instanceof EReference) {
                throw new UnsupportedOperationException("EReference id's not yet supported, eclass " + eClass.getName());
            }
            idEAttribute = (EAttribute)eFeature;
            break;
        }
        if (idEAttribute == null) {
            throw new IllegalStateException("Not possible to determine id eattribute for eClass " + eClass);
        }
        this.idEAttributes.put(eClass, idEAttribute);
        return idEAttribute;
    }
}

