/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.store;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.texo.model.ModelConstants;
import org.eclipse.emf.texo.provider.IdProvider;
import org.eclipse.emf.texo.resolver.DefaultObjectResolver;
import org.eclipse.emf.texo.utils.ModelUtils;

public abstract class EObjectStore
extends DefaultObjectResolver {
    public EObject getFromQualifiedIdString(String qualifiedIdString) {
        String idString;
        URI theUri = this.getUri().appendFragment(qualifiedIdString);
        EObject eObject = this.getEObject(theUri);
        if (eObject != null && !eObject.eIsProxy()) {
            return eObject;
        }
        int separatorIndex = qualifiedIdString.indexOf("||");
        if (separatorIndex == -1) {
            throw new IllegalArgumentException("Fragment format not supported for fragment: " + qualifiedIdString);
        }
        EClass eClass = ModelUtils.getEClassFromQualifiedName(qualifiedIdString.substring(0, separatorIndex));
        eObject = this.loadEObject(eClass, idString = qualifiedIdString.substring(separatorIndex + ModelConstants.FRAGMENTSEPARATOR_LENGTH));
        if (eObject == null) {
            return null;
        }
        this.addToCache(eObject);
        ((InternalEObject)eObject).eSetProxyURI(null);
        return eObject;
    }

    public EObject get(EClass eClass, Object id) {
        return this.getFromQualifiedIdString(String.valueOf(ModelUtils.getQualifiedNameFromEClass(eClass)) + "||" + id);
    }

    protected abstract EObject loadEObject(EClass var1, String var2);

    public String getQualifiedIdString(EObject eObject) {
        EAttribute eAttribute = IdProvider.getInstance().getIdEAttribute(eObject.eClass());
        if (eObject.eGet((EStructuralFeature)eAttribute) != null) {
            EDataType eDataType = eAttribute.getEAttributeType();
            String idString = eDataType.getEPackage().getEFactoryInstance().convertToString(eDataType, eObject.eGet((EStructuralFeature)eAttribute));
            String result = String.valueOf(ModelUtils.getQualifiedNameFromEClass(eObject.eClass())) + "||" + idString;
            return result;
        }
        return null;
    }

    public abstract void persist(List<EObject> var1, List<EObject> var2, List<EObject> var3);

    public abstract List<EObject> query(String var1, Map<String, Object> var2, int var3, int var4);

    public abstract void refresh(EObject var1);

    public abstract List<EObject> getReferingObjects(EObject var1, int var2, boolean var3);

    public abstract long count(String var1, Map<String, Object> var2);

    protected void deleted(EObject deletedEObject) {
        URI theUri = this.getUri().appendFragment(this.getQualifiedIdString(deletedEObject));
        this.removeFromCache(theUri);
    }
}

