/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.utils;

public class Check {
    public static void fail(String message) {
        throw new IllegalStateException(message);
    }

    public static void isTrue(boolean value, String message) {
        if (!value) {
            throw new IllegalStateException(message);
        }
    }

    public static void isFalse(boolean value, String message) {
        if (value) {
            throw new IllegalStateException(message);
        }
    }

    public static void isNotNull(Object value, String message) {
        if (value == null) {
            throw new IllegalStateException(message);
        }
    }

    public static void isNotNullArgument(Object value, String parameterName) {
        if (value == null) {
            throw new IllegalArgumentException(String.valueOf(parameterName) + " is not set.");
        }
    }

    public static void isNull(Object value, String message) {
        if (value != null) {
            throw new IllegalStateException(message);
        }
    }

    public static void isNotEmpty(Object[] array, String message) {
        if (array == null || array.length == 0) {
            throw new IllegalStateException(message);
        }
    }

    public static void isNotEmpty(String value, String message) {
        if (value == null || value.length() == 0) {
            throw new IllegalStateException(message);
        }
    }

    public static void isInstanceOf(Object obj, Class<?> expClass) {
        if (obj == null) {
            return;
        }
        if (!expClass.isAssignableFrom(obj.getClass())) {
            throw new IllegalStateException("Expected class: " + expClass.getName() + " but object has class: " + obj.getClass().getName());
        }
    }

    public static void isSameObject(Object obj1, Object obj2) {
        if (obj1 != obj2) {
            throw new IllegalStateException("Objects are not the same");
        }
    }

    public static void isNotSameObject(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            throw new IllegalStateException("Objects are not the same");
        }
    }

    private Check() {
    }
}

