/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.json.JSONValueConverter;
import org.eclipse.emf.texo.server.model.request.Parameter;
import org.eclipse.emf.texo.server.model.request.QueryType;
import org.eclipse.emf.texo.server.model.request.RequestModelPackage;
import org.eclipse.emf.texo.server.service.QueryChecker;
import org.eclipse.emf.texo.server.service.ServiceContext;
import org.eclipse.emf.texo.store.ObjectStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelOperation
implements TexoComponent {
    private static final String FALSE = Boolean.FALSE.toString();
    private ServiceContext serviceContext;

    public void execute() {
        block4: {
            try {
                if (this.getObjectStore() != null) {
                    this.getObjectStore().begin();
                }
                this.internalExecute();
                if (this.getObjectStore() != null) {
                    this.getObjectStore().commit();
                }
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                this.getServiceContext().createErrorResult(t);
                if (this.getObjectStore() == null) break block4;
                this.getObjectStore().rollback();
            }
        }
    }

    protected abstract void internalExecute();

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public ObjectStore getObjectStore() {
        return this.getServiceContext().getObjectStore();
    }

    protected QueryType getQueryType() {
        QueryType queryType = null;
        if (this.getServiceContext().getRequestContent() != null && this.getServiceContext().getRequestContent().trim().length() > 0) {
            List<Object> requestData = this.getServiceContext().getRequestData();
            for (Object object : requestData) {
                if (!(object instanceof QueryType)) continue;
                queryType = (QueryType)object;
                break;
            }
        }
        boolean queryTypeFromContent = queryType != null;
        String namedQueryParam = (String)this.getServiceContext().getRequestParameters().get("namedQuery");
        String qryStrParam = (String)this.getServiceContext().getRequestParameters().get("query");
        if (queryType == null && qryStrParam != null && qryStrParam.trim().length() > 0) {
            this.getServiceContext().getServiceOptions().checkFalse("allowQuerying");
            queryType = RequestModelPackage.INSTANCE.getModelFactory().createQueryType();
            queryType.setQuery(qryStrParam);
        } else if (queryType == null && namedQueryParam != null) {
            queryType = RequestModelPackage.INSTANCE.getModelFactory().createQueryType();
            queryType.setNamedQuery(namedQueryParam);
        }
        if (queryType == null) {
            return queryType;
        }
        if (!queryTypeFromContent) {
            queryType.setFirstResult(this.getFirstResult());
            queryType.setMaxResults(this.getMaxResults());
            String noCountParam = (String)this.getServiceContext().getRequestParameters().get("noCount");
            queryType.setDoCount(noCountParam == null || FALSE.equals(noCountParam));
        }
        if (queryType.getQuery() != null) {
            ((QueryChecker)ComponentProvider.getInstance().newInstance(QueryChecker.class)).checkQuery(queryType.getQuery());
        }
        if (queryType.getMaxResults() == -1) {
            queryType.setDoCount(false);
        }
        return queryType;
    }

    protected Map<String, Object> getParameters(QueryType queryType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : this.getServiceContext().getRequestParameters().keySet()) {
            if (!key.startsWith("qp.")) continue;
            Object value = this.getServiceContext().getRequestParameters().get(key);
            String name = key.substring("qp.".length());
            result.put(name, value);
        }
        if (queryType == null) {
            return result;
        }
        JSONValueConverter converter = (JSONValueConverter)ComponentProvider.getInstance().newInstance(JSONValueConverter.class);
        for (Parameter parameter : queryType.getParameters()) {
            String type = parameter.getType();
            Object value = parameter.getValue();
            if (type != null) {
                value = "date".equals(type) ? converter.createDateFromJSON(value) : ("dateTime".equals(type) ? converter.createDateTimeFromJSON(value) : converter.createTimeFromJSON(value));
            }
            result.put(parameter.getName(), value);
        }
        return result;
    }

    protected int getFirstResult() {
        return this.getNumberParameter("firstResult");
    }

    protected int getMaxResults() {
        return this.getNumberParameter("maxResults");
    }

    private int getNumberParameter(String paramName) {
        if (this.getServiceContext().getRequestParameters().containsKey(paramName)) {
            try {
                return Integer.parseInt((String)this.getServiceContext().getRequestParameters().get(paramName));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public void close() {
        if (this.getObjectStore() != null) {
            this.getObjectStore().close();
        }
    }
}

