/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.store;

import java.io.IOException;
import javax.persistence.EntityManager;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.emf.texo.server.store.EntityManagerProvider;

public class CurrentEntityManagerRequestFilter
implements Filter {
    public void init(FilterConfig fConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean errorOccurred = true;
        try {
            chain.doFilter(request, response);
            errorOccurred = false;
        }
        finally {
            if (!EntityManagerProvider.getInstance().hasCurrentEntityManager()) {
                return;
            }
            EntityManager entityManager = EntityManagerProvider.getInstance().getCurrentEntityManager();
            boolean errorWhileClosing = true;
            try {
                if (entityManager.isOpen() && entityManager.getTransaction().isActive()) {
                    if (errorOccurred) {
                        try {
                            entityManager.getTransaction().rollback();
                        }
                        catch (Throwable t) {
                            try {
                                EntityManagerProvider.getInstance().clearCurrentEntityManager();
                            }
                            catch (Throwable t2) {
                                if (errorOccurred || errorWhileClosing) {
                                    return;
                                }
                                throw new ServletException(t2);
                            }
                            return;
                        }
                    }
                    entityManager.getTransaction().commit();
                }
                errorWhileClosing = false;
            }
            finally {
                try {
                    EntityManagerProvider.getInstance().clearCurrentEntityManager();
                }
                catch (Throwable t) {
                    if (errorOccurred || errorWhileClosing) {
                        return;
                    }
                    throw new ServletException(t);
                }
            }
        }
    }
}

