/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.store;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.component.TexoStaticSingleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerProvider
implements TexoComponent,
TexoStaticSingleton {
    public static final String ECLIPSELINK_CLASSLOADER_OPTION = "eclipselink.classloader";
    public static final String MULTITENANT_PROPERTY_DEFAULT = "eclipselink.tenant-id";
    private static EntityManagerProvider instance = (EntityManagerProvider)ComponentProvider.getInstance().newInstance(EntityManagerProvider.class);
    private ThreadLocal<EntityManager> currentEntityManager = new ThreadLocal();
    private EntityManagerFactory entityManagerFactory;
    private String persistenceUnitName;
    private Map<Object, Object> persistenceOptions = new HashMap<Object, Object>();
    private boolean useCurrentEntityManagerPattern = false;

    public static EntityManagerProvider getInstance() {
        return instance;
    }

    public static void setInstance(EntityManagerProvider entityManagerProvider) {
        instance = entityManagerProvider;
    }

    public void initialize() {
        if (this.entityManagerFactory != null) {
            return;
        }
        if (this.persistenceOptions != null) {
            if (!this.persistenceOptions.containsKey(ECLIPSELINK_CLASSLOADER_OPTION)) {
                this.persistenceOptions.put(ECLIPSELINK_CLASSLOADER_OPTION, EntityManagerProvider.class.getClassLoader());
            }
            this.persistenceOptions.put(MULTITENANT_PROPERTY_DEFAULT, "texo");
            this.entityManagerFactory = Persistence.createEntityManagerFactory((String)this.persistenceUnitName, this.persistenceOptions);
        } else {
            this.entityManagerFactory = Persistence.createEntityManagerFactory((String)this.persistenceUnitName);
        }
    }

    public EntityManager createEntityManager() {
        this.initialize();
        return this.entityManagerFactory.createEntityManager();
    }

    public EntityManager getEntityManager() {
        if (this.isUseCurrentEntityManagerPattern()) {
            return this.getCurrentEntityManager();
        }
        return this.createEntityManager();
    }

    public EntityManager getCurrentEntityManager() {
        if (this.currentEntityManager.get() != null) {
            return this.currentEntityManager.get();
        }
        this.currentEntityManager.set(this.createEntityManager());
        this.currentEntityManager.get().getTransaction().begin();
        return this.currentEntityManager.get();
    }

    public void setCurrentEntityManager(EntityManager entityManager) {
        if (this.currentEntityManager.get() != null) {
            this.currentEntityManager.get().close();
        }
        this.currentEntityManager.set(entityManager);
    }

    public void clearCurrentEntityManager() {
        if (this.currentEntityManager.get() != null) {
            if (this.currentEntityManager.get().isOpen()) {
                this.currentEntityManager.get().close();
            }
            this.currentEntityManager.set(null);
        }
    }

    public boolean hasCurrentEntityManager() {
        return this.currentEntityManager.get() != null;
    }

    public void releaseEntityManager(EntityManager entityManager) {
        if (entityManager.isOpen()) {
            entityManager.close();
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public Map<Object, Object> getPersistenceOptions() {
        return this.persistenceOptions;
    }

    public void setPersistenceOptions(Map<Object, Object> persistenceOptions) {
        this.persistenceOptions = persistenceOptions;
    }

    public boolean isUseCurrentEntityManagerPattern() {
        return this.useCurrentEntityManagerPattern;
    }

    public void setUseCurrentEntityManagerPattern(boolean useCurrentEntityManagerPattern) {
        this.useCurrentEntityManagerPattern = useCurrentEntityManagerPattern;
    }
}

