/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.model.ModelPackage;
import org.eclipse.emf.texo.server.service.ServiceModelPackageRegistry;
import org.eclipse.emf.texo.server.web.WebServiceHandler;
import org.eclipse.emf.texo.server.web.XMLRestWebServiceHandler;
import org.eclipse.emf.texo.utils.ModelUtils;

public class DataModelBrowserServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String ACTION_PARAMETER = "action";
    private static final String GENERATE_TEST_DATA_ACTION = "testData".toLowerCase();
    private static final String TEMPLATE_PARAMETER = "template";
    private static final String TYPE_PARAMETER = "type";
    private static final String TYPE_PARAMETER_XML = "xml";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        String result = "";
        if (pathInfo == null || pathInfo.trim().length() == 0) {
            result = this.getEPackageList(req);
            resp.setContentType("text/html;charset=UTF-8");
        } else {
            String name = pathInfo.substring(1);
            if (name.contains("/")) {
                int segmentIndex = name.indexOf("/");
                name = name.substring(0, segmentIndex);
            }
            if (pathInfo.contains("|")) {
                if (name.contains("/")) {
                    name = name.substring(0, name.indexOf("/"));
                }
                EClass eClass = ModelUtils.getEClassFromQualifiedName((String)name);
                this.doGetInstances(eClass, req, resp);
            } else {
                name = name.toLowerCase();
                for (ModelPackage modelPackage : ServiceModelPackageRegistry.getInstance().getRegisteredModelPackages()) {
                    if (!modelPackage.getEPackage().getName().toLowerCase().equals(name)) continue;
                    result = req.getParameter(ACTION_PARAMETER) != null && req.getParameter(ACTION_PARAMETER).toLowerCase().equals(GENERATE_TEST_DATA_ACTION) ? this.generatePersistTestData(modelPackage.getEPackage()) : this.getTypes(req, modelPackage.getEPackage());
                    resp.setContentType("text/html;charset=UTF-8");
                    break;
                }
            }
        }
        if (result == null) {
            result = "No results found using this url";
        }
        resp.getWriter().write(result);
    }

    protected String generatePersistTestData(EPackage ePackage) {
        return "The test data generation should be implemented in a subclass of this servlet";
    }

    protected String getEPackageList(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><h1>Registered Model Packages</h1>");
        sb.append("<table>");
        for (ModelPackage modelPackage : ServiceModelPackageRegistry.getInstance().getRegisteredModelPackages()) {
            sb.append("<tr><td><b>");
            sb.append(String.valueOf(modelPackage.getEPackage().getName()) + " --> ");
            sb.append("</b></td><td>");
            sb.append("<a href='" + req.getContextPath() + req.getServletPath() + "/" + modelPackage.getEPackage().getName() + "'>Browse Types</a>");
            sb.append("</td><td>");
            sb.append("<a href='" + req.getContextPath() + req.getServletPath() + "/" + modelPackage.getEPackage().getName() + "?" + ACTION_PARAMETER + "=" + GENERATE_TEST_DATA_ACTION + "'>Generate Test Data</a>");
            sb.append("</td><tr>");
        }
        sb.append("</table></body></html>");
        return sb.toString();
    }

    protected String getTypes(HttpServletRequest req, EPackage ePackage) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><h1>Types list for EPackage " + ePackage.getName() + "</h1>");
        sb.append("<table>");
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            sb.append("<tr><td>");
            sb.append("<a href='" + req.getContextPath() + req.getServletPath() + "/" + ModelUtils.getQualifiedNameFromEClass((EClass)eClass) + "?" + TEMPLATE_PARAMETER + "=instances.xslt'>" + eClass.getName() + "</a> ");
            sb.append("<a href='" + req.getContextPath() + req.getServletPath() + "/" + ModelUtils.getQualifiedNameFromEClass((EClass)eClass) + "'>(xml)</a>");
            sb.append("</td><tr>");
        }
        sb.append("</table></body></html>");
        return sb.toString();
    }

    protected void doGetInstances(EClass eClass, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String templateLocation = req.getParameter(TEMPLATE_PARAMETER);
        String type = req.getParameter(TYPE_PARAMETER);
        WebServiceHandler webServiceHandler = this.createWebServiceHandler(type == null || type.equalsIgnoreCase(TYPE_PARAMETER_XML));
        if (templateLocation != null) {
            WebServiceHandler.XSLTServiceContextResultProcessor serviceContextResultProcessor = (WebServiceHandler.XSLTServiceContextResultProcessor)ComponentProvider.getInstance().newInstance(WebServiceHandler.XSLTServiceContextResultProcessor.class);
            serviceContextResultProcessor.setTemplateClassPathLocation(templateLocation);
            webServiceHandler.setServiceContextResultProcessor(serviceContextResultProcessor);
            serviceContextResultProcessor.addParameter("eClassName", eClass.getName());
            serviceContextResultProcessor.addParameter("qualifiedEClassName", ModelUtils.getQualifiedNameFromEClass((EClass)eClass));
        }
        webServiceHandler.doGet(req, resp);
    }

    protected WebServiceHandler createWebServiceHandler(boolean xml) {
        if (xml) {
            return (WebServiceHandler)ComponentProvider.getInstance().newInstance(XMLRestWebServiceHandler.class);
        }
        throw new IllegalArgumentException("Unsupported type of web service handler");
    }

    protected String getInstance(EClass eClass, Object id) {
        return null;
    }

    public String applyTemplate(String xml, InputStream template) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(template));
            StreamSource source = new StreamSource(new StringReader(xml));
            StringWriter sw = new StringWriter();
            StreamResult response = new StreamResult(sw);
            transformer.transform(source, response);
            return sw.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

